import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:road24_mobile/data/repository/InspectionsRepository.dart';
import 'package:road24_mobile/data/response/manual_part/inspection/RegionsModel.dart';
import 'package:road24_mobile/model/blocs/inspections/inspections_bloc.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/widgets/fade_route.dart';
import 'package:road24_mobile/view/widgets/no_connection_screen.dart';
import '../../../../my_app.dart';
import 'InspectionPlaces/inspection_places.dart';

class InspectionManual extends StatefulWidget {
  const InspectionManual({Key? key}) : super(key: key);

  @override
  _InspectionManualState createState() => _InspectionManualState();
}

class _InspectionManualState extends State<InspectionManual> {
  var inpectionBloc = InspectionsBloc(repository: InspectionsRepository());

  List<Regions> regions = [];

  @override
  void initState() {
    super.initState();
    onRefresh();
  }

  @override
  void dispose() {
    inpectionBloc.close();
    super.dispose();
  }

  Future<void> onRefresh() async {
    inpectionBloc.add(GetRegionsEvent());
  }

  @override
  Widget build(BuildContext context) {
    return ValueListenableBuilder(
        valueListenable: MyApp.hasInternet,
        builder: (context, bool hasInternet, _) {
          return (hasInternet)
              ? Scaffold(
                  backgroundColor: AppColors.appPrimaryColor,
                  appBar: _appBar(),
                  body: _bodyWeHaveData(),
                )
              : NoConnectionScreen(onTap: () {
                  Navigator.pushReplacement(
                    context,
                    FadeRoute(page: const InspectionManual()),
                  );
                });
        });
  }

  AppBar _appBar() {
    return AppBar(
      toolbarHeight: 60.0,
      centerTitle: true,
      leading: InkWell(
        onTap: () => Navigator.pop(context),
        child: Container(
          margin: const EdgeInsets.all(10),
          decoration: BoxDecoration(
            color: Color(0xffDFDFDF),
            shape: BoxShape.circle,
          ),
          child: const Center(
            child: Icon(
              Icons.arrow_back_ios_outlined,
              size: 20.0,
              color: Colors.black,
            ),
          ),
        ),
      ),
      title: Text(S.of(context).manual_inspection,
          style: AppStyle.textStyle().copyWith(
              color: Colors.black, fontWeight: FontWeight.w600, fontSize: 18.0),
          maxLines: 2,
          textAlign: TextAlign.center),
      actions: [
        const SizedBox(
          width: 30,
        )
      ],
    );
  }

  // Widget _bodyWeHaveNotData() {
  //   return Center(
  //     child: Padding(
  //       padding: const EdgeInsets.symmetric(horizontal: 8.0),
  //       child: Text(
  //         S.of(context).error_on_system,
  //         style: AppStyle.textStyle().copyWith(
  //           color: Color(0xff282828),
  //           fontSize: 16.0,
  //           fontWeight: FontWeight.w500,
  //         ),
  //       ),
  //     ),
  //   );
  // }

  Widget _bodyWeHaveData() {
    return BlocBuilder(
        bloc: inpectionBloc,
        builder: (context, state) {
          if (state is GetRegionSuccessState) {
            regions.clear();
            regions.addAll(state.regions);
          }

          return Column(
            crossAxisAlignment: CrossAxisAlignment.start,
            children: [
              Padding(
                padding: const EdgeInsets.all(16.0),
                child: Text(
                  S.of(context).choose_city_or_region,
                  style: AppStyle.textStyle().copyWith(
                      color: Color(0xff282828),
                      fontSize: 24.0,
                      fontWeight: FontWeight.w700),
                  maxLines: 2,
                ),
              ),
              SizedBox(height: 10.0),
              Expanded(
                child: (state is LoadingState)
                    ? Center(
                        child: Padding(
                        padding: const EdgeInsets.only(bottom: 8.0),
                        child: CircularProgressIndicator(),
                      ))
                    : RefreshIndicator(
                        color: Colors.grey,
                        onRefresh: onRefresh,
                        child: ListView.separated(
                            padding: EdgeInsets.symmetric(
                                vertical: 4, horizontal: 16),
                            shrinkWrap: true,
                            itemCount: regions.length,
                            separatorBuilder: (context, index) =>
                                Divider(height: 1, color: Color(0XFFCACACA)),
                            itemBuilder: (context, int index) {
                              return Container(
                                height: 56.0,
                                child: Column(
                                  mainAxisAlignment:
                                      MainAxisAlignment.spaceAround,
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    Expanded(
                                      child: InkWell(
                                        onTap: () {
                                          Navigator.push(
                                            context,
                                            CupertinoPageRoute(
                                              builder: (context) =>
                                                  InspectionPlaces(
                                                regionName: regions[index].name,
                                                regionId: regions[index].id,
                                              ),
                                            ),
                                          );
                                        },
                                        child: Row(
                                          mainAxisAlignment:
                                              MainAxisAlignment.spaceBetween,
                                          children: [
                                            Expanded(
                                              flex: 5,
                                              child: Padding(
                                                padding: EdgeInsets.symmetric(
                                                    horizontal: 5.0),
                                                child: Text(
                                                  regions[index].name,
                                                  style: AppStyle.textStyle()
                                                      .copyWith(
                                                          color:
                                                              Color(0xff282828),
                                                          fontWeight:
                                                              FontWeight.w400,
                                                          fontSize: 16.0),
                                                ),
                                              ),
                                            ),
                                            Expanded(
                                              flex: 1,
                                              child: Padding(
                                                padding:
                                                    const EdgeInsets.symmetric(
                                                        horizontal: 8.0),
                                                child: Icon(
                                                  Icons.chevron_right,
                                                  color:
                                                      AppColors.unSelectedColor,
                                                ),
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                    ),
                                  ],
                                ),
                              );
                            }),
                      ),
              ),
            ],
          );
        });
  }
}
