import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:road24_mobile/data/response/manual_part/inspection/InspectionManualResponse.dart';
import 'package:road24_mobile/data/response/manual_part/inspection/RegionsModel.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/widgets/items/list_of_places_item_new.dart';

import 'details_new.dart';

class ListOfPlaces extends StatelessWidget {
  final String regionName;
  final List<Address> listOfPlaces;
  final List<Districts> districts;

  const ListOfPlaces(
      {Key? key,
      required this.listOfPlaces,
      required this.regionName,
      required this.districts})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      margin: const EdgeInsets.symmetric(horizontal: 16.0),
      child: Column(
        crossAxisAlignment: CrossAxisAlignment.start,
        children: [
          const SizedBox(height: 8.0),
          Padding(
            padding: const EdgeInsets.symmetric(horizontal: 3.0, vertical: 4.0),
            child: Text(
              regionName,
              style: AppStyle.textStyle().copyWith(
                  color: Color(0xff282828),
                  fontSize: 24.0,
                  fontWeight: FontWeight.w700),
            ),
          ),
          const SizedBox(height: 8.0),
          Expanded(
            child: SingleChildScrollView(
              physics: const AlwaysScrollableScrollPhysics(),
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.spaceAround,
                children: [
                  ...List.generate(listOfPlaces.length, (index) {
                    var districtName = "";

                    try {
                      var district = districts.firstWhere(
                        (element) =>
                            element.id == listOfPlaces[index].districtId,
                      );
                      if (district != null) districtName = district.name;
                    } catch (ex) {
                      print(
                          "exccc $ex.....${listOfPlaces[index].districtId} ${listOfPlaces[index].name}");
                    }
                    var address = "";
                    if (listOfPlaces[index].address != null)
                      address = ", " + (listOfPlaces[index].address ?? "");
                    if (!address.contains(districtName))
                      listOfPlaces[index].address = districtName + "" + address;
                    return Column(
                      children: [
                        GestureDetector(
                          onTap: () {
                            Navigator.push(
                                context,
                                CupertinoPageRoute(
                                    builder: (context) => Details(
                                          placeItem: listOfPlaces[index],
                                        )));
                          },
                          child: ListOfPlacesItem(
                            placeItem: listOfPlaces[index],
                          ),
                        ),
                        const SizedBox(height: 8.0),
                      ],
                    );
                  }),
                  const SizedBox(height: 50.0),
                ],
              ),
            ),
          ),
        ],
      ),
    );
  }
}
