import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';

class BoxWidget extends StatelessWidget {
  final Color color;
  final Color titleColor;
  final String title;
  final bool background;

  const BoxWidget(
      {Key? key,
      required this.color,
      required this.title,
      required this.titleColor,
      this.background = true})
      : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Container(
      height: 24.0,
      padding: const EdgeInsets.symmetric(horizontal: 8.0),
      // margin: EdgeInsets.all(2.0),
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(8.0),
        border: Border.all(
          width: 1.0,
          color: color,
        ),
        color: background ? color.withOpacity(0.16) : null,
      ),
      child: Text(
        title,
        style: AppStyle.textStyle().copyWith(
          fontSize: 12,
          fontWeight: FontWeight.w500,
          color: titleColor,
        ),
        textAlign: TextAlign.center,
      ),
    );
  }
}

class ServiceTypes extends StatelessWidget {
  final bool legal;
  final bool individual;
  final bool texpassport;
  final bool prava;

  const ServiceTypes({
    Key? key,
    required this.legal,
    required this.individual,
    required this.texpassport,
    required this.prava,
  }) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return Wrap(
      spacing: 8.0,
      runSpacing: 8.0,
      children: [
        if (texpassport)
          BoxWidget(
            color: AppColors.selectedColor,
            title: S.of(context).texpassport,
            titleColor: Color(0xff282828),
            background: false,
          ),
        if (prava)
          BoxWidget(
            color: AppColors.selectedColor,
            title: S.of(context).licenseExam,
            titleColor: Color(0xff282828),
            background: false,
          ),
        if (legal)
          BoxWidget(
            color: AppColors.color27ae60,
            title: S.of(context).texJuridic,
            titleColor: Color(0xff27AE60),
            background: false,
          ),
        if (individual)
          BoxWidget(
            color: AppColors.color2d9cdb,
            title: S.of(context).texPhysical,
            titleColor: Color(0xff2D9CDB),
            background: false,
          ),
      ],
    );
  }
}
