import 'package:auto_size_text/auto_size_text.dart';
import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:map_launcher/map_launcher.dart';
import 'package:road24_mobile/data/response/manual_part/inspection/InspectionManualResponse.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/widgets/fade_route.dart';
import 'package:road24_mobile/view/widgets/no_connection_screen.dart';
import 'package:url_launcher/url_launcher.dart';

import '../../../../../my_app.dart';
import 'inspection_widgets.dart';

class Details extends StatelessWidget {
  final Address placeItem;

  const Details({
    Key? key,
    required this.placeItem,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return ValueListenableBuilder(
        valueListenable: MyApp.hasInternet,
        builder: (context, bool hasInternet, _) {
          return (hasInternet)
              ? Scaffold(
                  backgroundColor: AppColors.appPrimaryColor,
                  appBar: appBar(context),
                  body: Padding(
                    padding: const EdgeInsets.symmetric(horizontal: 16.0),
                    child: SingleChildScrollView(
                      child: Column(
                        crossAxisAlignment: CrossAxisAlignment.start,
                        children: [
                          // AutoSizeText(
                          //   "${placeItem.name}",
                          //   style: AppStyle.textStyle().copyWith(
                          //       color: Color(0xff282828),
                          //       fontWeight: FontWeight.w700,
                          //       fontSize: 24.0),
                          // ),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              // SizedBox(height: 4.0),
                              AutoSizeText(
                                "${placeItem.type}",
                                style: AppStyle.textStyle().copyWith(
                                  fontWeight: FontWeight.w400,
                                  fontSize: 16.0,
                                  color: Color(0xff282828),
                                ),
                              ),
                              const SizedBox(height: 16.0),
                              const Divider(
                                height: 1.0,
                                color: AppColors.unSelectedColor,
                              ),
                              const SizedBox(height: 16.0),
                            ],
                          ),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              AutoSizeText(
                                "${S.of(context).services}".toUpperCase(),
                                style: AppStyle.textStyle().copyWith(
                                  fontWeight: FontWeight.w600,
                                  fontSize: 15.0,
                                  color: Color(0xff282828),
                                ),
                              ),
                              const SizedBox(height: 8.0),
                              ServiceTypes(
                                legal: placeItem.legalEntityService,
                                individual: placeItem.individualService,
                                texpassport: placeItem.texpasportService,
                                prava: placeItem.licenseService,
                              ),
                              const SizedBox(height: 16.0),
                              const Divider(
                                height: 1.0,
                                color: AppColors.unSelectedColor,
                              )
                            ],
                          ),
                          const SizedBox(height: 16.0),
                          if (placeItem.serviceProvince != null)
                            Column(
                                mainAxisAlignment: MainAxisAlignment.start,
                                crossAxisAlignment: CrossAxisAlignment.start,
                                children: [
                                  AutoSizeText(
                                    "${S.of(context).serving_districts}"
                                        .toUpperCase(),
                                    style: AppStyle.textStyle().copyWith(
                                      fontWeight: FontWeight.w600,
                                      fontSize: 15.0,
                                      color: Color(0xff282828),
                                    ),
                                  ),
                                  const SizedBox(height: 8.0),
                                  Wrap(
                                    spacing: 8.0,
                                    runSpacing: 8.0,
                                    children: List.generate(
                                        placeItem.serviceProvince!
                                            .split(";")
                                            .length, (index) {
                                      var title = placeItem.serviceProvince!
                                          .split(";")[index]
                                          .toString()
                                          .trim();
                                      if (title != "")
                                        return BoxWidget(
                                          color: AppColors.selectedColor,
                                          title: placeItem.serviceProvince!
                                              .split(";")[index]
                                              .toString(),
                                          titleColor: Color(0xff282828),
                                          background: false,
                                        );

                                      return const SizedBox();
                                    }),
                                  ),
                                  const SizedBox(height: 16.0),
                                  const Divider(
                                    height: 1.0,
                                    color: AppColors.unSelectedColor,
                                  ),
                                  const SizedBox(height: 16.0),
                                ]),
                          AutoSizeText(
                            S.of(context).location.toUpperCase(),
                            style: AppStyle.textStyle().copyWith(
                              fontWeight: FontWeight.w600,
                              fontSize: 15.0,
                              color: Color(0xff282828),
                            ),
                          ),
                          const SizedBox(height: 8.0),
                          Row(
                            mainAxisAlignment: MainAxisAlignment.start,
                            children: [
                              Container(
                                width: 48.0,
                                height: 48.0,
                                decoration: BoxDecoration(
                                  color: AppColors.colore8e8e8,
                                  shape: BoxShape.circle,
                                ),
                                child: Center(
                                  child: SvgPicture.asset("assets/svg/map.svg"),
                                ),
                              ),
                              const SizedBox(width: 12.0),
                              Flexible(
                                child: AutoSizeText(
                                  // 'Республика Каракалпакистан, гор. Нукус, улица Касымова, 27',
                                  "${placeItem.address}",
                                  style: AppStyle.textStyle().copyWith(
                                    fontSize: 15.0,
                                    fontWeight: FontWeight.w500,
                                    color: Color(0xff282828),
                                  ),
                                  maxLines: 3,
                                  textAlign: TextAlign.start,
                                ),
                              ),
                            ],
                          ),
                          const SizedBox(height: 6.0),
                          Align(
                            alignment: Alignment.center,
                            child: GestureDetector(
                              onTap: () async {
                                var isMapAvailable =
                                    await MapLauncher.isMapAvailable(
                                        MapType.google);
                                if (isMapAvailable != null && isMapAvailable) {
                                  print(placeItem.geolocatoin);
                                  MapLauncher.showDirections(
                                    mapType: MapType.google,
                                    destination: Coords(
                                      double.parse(
                                          placeItem.geolocatoin.split(",")[0]),
                                      double.parse(
                                          placeItem.geolocatoin.split(",")[1]),
                                      // placeItem.latLng!.longitude,
                                    ),
                                  );
                                } else {
                                  MapLauncher.installedMaps.then((value) {
                                    MapLauncher.showDirections(
                                      mapType: value.first.mapType,
                                      destination: Coords(
                                        double.parse(placeItem.geolocatoin
                                            .split(",")[0]),
                                        double.parse(placeItem.geolocatoin
                                            .split(",")[1]),
                                      ),
                                    );
                                  });
                                }
                              },
                              child: Container(
                                  padding: const EdgeInsets.symmetric(
                                      horizontal: 18.0),
                                  height: 36.0,
                                  width: 195.0,
                                  decoration: BoxDecoration(
                                    borderRadius: BorderRadius.circular(12.0),
                                    color: AppColors.color536AEE,
                                    boxShadow: [
                                      BoxShadow(
                                          color: AppColors.color536AEE
                                              .withOpacity(0.2),
                                          offset: Offset(5.0, 10.0),
                                          blurRadius: 12.0),
                                    ],
                                  ),
                                  child: Center(
                                    child: Row(
                                      mainAxisAlignment:
                                          MainAxisAlignment.center,
                                      crossAxisAlignment:
                                          CrossAxisAlignment.center,
                                      children: [
                                        const SizedBox(width: 4.0),
                                        SvgPicture.asset(
                                          'assets/svg/location.svg',
                                          color: Colors.white,
                                        ),
                                        const SizedBox(width: 18.0),
                                        Flexible(
                                          child: AutoSizeText(
                                            S.of(context).show_in_map,
                                            style: AppStyle.textStyle()
                                                .copyWith(
                                                    color: Colors.white,
                                                    fontWeight: FontWeight.w600,
                                                    fontSize: 18.0),
                                          ),
                                        ),
                                      ],
                                    ),
                                  )),
                            ),
                          ),
                          const SizedBox(height: 16.0),
                          const Divider(
                            height: 1.0,
                            color: AppColors.unSelectedColor,
                          ),
                          const SizedBox(height: 16.0),
                          Column(
                            crossAxisAlignment: CrossAxisAlignment.start,
                            children: [
                              Container(
                                height: 30.0,
                                child: AutoSizeText(
                                  S.of(context).working_time.toUpperCase(),
                                  style: AppStyle.textStyle().copyWith(
                                    fontWeight: FontWeight.w600,
                                    fontSize: 15.0,
                                    color: Color(0xff282828),
                                  ),
                                ),
                              ),
                              const SizedBox(height: 5.0),
                              Container(
                                  height: 58.0,
                                  decoration: BoxDecoration(
                                    color: Colors.white,
                                    borderRadius: BorderRadius.circular(16.0),
                                  ),
                                  child: Row(
                                    crossAxisAlignment:
                                        CrossAxisAlignment.center,
                                    children: [
                                      const SizedBox(width: 12.0),
                                      Container(
                                        width: 36.0,
                                        height: 36.0,
                                        decoration: BoxDecoration(
                                          color: AppColors.colore8e8e8,
                                          shape: BoxShape.circle,
                                        ),
                                        child: Center(
                                          child: SvgPicture.asset(
                                              "assets/svg/timer.svg",
                                              width: 18,
                                              height: 20.0),
                                        ),
                                      ),
                                      const SizedBox(width: 12.0),
                                      Expanded(
                                        child: Column(
                                          mainAxisAlignment:
                                              MainAxisAlignment.center,
                                          crossAxisAlignment:
                                              CrossAxisAlignment.start,
                                          children: [
                                            AutoSizeText(
                                              "${placeItem.workingDays}",
                                              style:
                                                  AppStyle.textStyle().copyWith(
                                                fontWeight: FontWeight.w500,
                                                fontSize: 16.0,
                                                color: Color(0xff282828),
                                              ),
                                            ),
                                            AutoSizeText(
                                              "${S.of(context).dinnerTime} ${placeItem.dinner}",
                                              style:
                                                  AppStyle.textStyle().copyWith(
                                                fontWeight: FontWeight.w500,
                                                fontSize: 16.0,
                                                color: Color(0xff282828),
                                              ),
                                            ),
                                          ],
                                        ),
                                      ),
                                    ],
                                  )),
                            ],
                          ),
                          if (placeItem.phone != null)
                            Column(
                              mainAxisAlignment: MainAxisAlignment.start,
                              crossAxisAlignment: CrossAxisAlignment.start,
                              children: [
                                const SizedBox(height: 16.0),
                                const Divider(
                                    height: 1.0,
                                    color: AppColors.unSelectedColor),
                                const SizedBox(height: 16.0),
                                Container(
                                  height: 30.0,
                                  child: AutoSizeText(
                                    S.of(context).phone_number.toUpperCase(),
                                    style: AppStyle.textStyle().copyWith(
                                      fontWeight: FontWeight.w600,
                                      fontSize: 15.0,
                                      color: Color(0xff282828),
                                    ),
                                  ),
                                ),
                                for (int i = 0;
                                    i < (placeItem.phone1 != null ? 2 : 1);
                                    i++)
                                  Column(
                                    children: [
                                      const SizedBox(height: 5.0),
                                      GestureDetector(
                                        onTap: () {
                                          launch(
                                              "tel://${i == 0 ? placeItem.phone : placeItem.phone1}");
                                        },
                                        child: Container(
                                          height: 58.0,
                                          decoration: BoxDecoration(
                                            color: Colors.white,
                                            borderRadius:
                                                BorderRadius.circular(16.0),
                                          ),
                                          child: Row(
                                            crossAxisAlignment:
                                                CrossAxisAlignment.center,
                                            children: [
                                              const SizedBox(width: 12.0),
                                              Container(
                                                width: 36.0,
                                                height: 36.0,
                                                decoration: BoxDecoration(
                                                  color: AppColors.colore8e8e8,
                                                  shape: BoxShape.circle,
                                                ),
                                                child: Center(
                                                  child: SvgPicture.asset(
                                                      "assets/svg/phone.svg",
                                                      width: 18,
                                                      height: 20.0),
                                                ),
                                              ),
                                              const SizedBox(width: 12.0),
                                              AutoSizeText(
                                                "${i == 0 ? placeItem.phone : placeItem.phone1}",
                                                style: AppStyle.textStyle()
                                                    .copyWith(
                                                  fontWeight: FontWeight.w500,
                                                  fontSize: 14.0,
                                                  color: Color(0xff282828),
                                                ),
                                              ),
                                            ],
                                          ),
                                        ),
                                      ),
                                      const SizedBox(height: 8.0),
                                    ],
                                  ),
                              ],
                            ),
                          const SizedBox(height: 100.0),
                        ],
                      ),
                    ),
                  ),
                )
              : NoConnectionScreen(onTap: () {
                  Navigator.pushReplacement(
                    context,
                    FadeRoute(page: Details(placeItem: placeItem)),
                  );
                });
        });
  }

  AppBar appBar(BuildContext context) {
    return AppBar(
      toolbarHeight: 60.0,
      centerTitle: true,
      backgroundColor: AppColors.appPrimaryColor,
      leading: Material(
        type: MaterialType.transparency,
        child: InkWell(
          onTap: () {
            Navigator.pop(context);
          },
          child: Container(
            margin: const EdgeInsets.all(10.0),
            decoration: const BoxDecoration(
              color: Color(0xffDFDFDF),
              shape: BoxShape.circle,
            ),
            child: const Center(
              child: Icon(
                Icons.arrow_back_ios_outlined,
                size: 20.0,
                color: Colors.black,
              ),
            ),
          ),
        ),
      ),
      title: AutoSizeText(
        placeItem.name,
        style: AppStyle.textStyle().copyWith(
            color: Colors.black, fontWeight: FontWeight.w600, fontSize: 18.0),
        maxLines: 2,
        textAlign: TextAlign.center,
      ),
    );
  }
}
