import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/manual/parts/fines/fines_manual.dart';

import 'details/thematic_details.dart';

class Thematics extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Padding(
          padding: const EdgeInsets.all(3.0),
          child: Text(
            S.of(context).thematics,
            style: AppStyle.textStyle().copyWith(
                color: Color(0xff282828),
                fontSize: 24.0,
                fontWeight: FontWeight.w700),
          ),
        ),
        const SizedBox(height: 10.0),
        Expanded(
          child: ListView.separated(
              shrinkWrap: true,
              itemBuilder: (context, index) {
                return Container(
                  height: 56.0,
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.spaceAround,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Expanded(
                        child: InkWell(
                          onTap: () {
                            print("go to thematic details");
                            Navigator.push(
                              context,
                              CupertinoPageRoute(
                                builder: (context) => ThematicDetails(
                                  category: FinesManual.categories[index],
                                ),
                              ),
                            );
                          },
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Flexible(
                                child: Padding(
                                  padding: const EdgeInsets.symmetric(
                                      horizontal: 5.0),
                                  child: Text(
                                    FinesManual
                                        .categories[index].articleCategories,
                                    maxLines: 2,
                                    overflow: TextOverflow.ellipsis,
                                    style: AppStyle.textStyle().copyWith(
                                        color: Color(0xff282828),
                                        fontWeight: FontWeight.w400,
                                        fontSize: 16.0),
                                  ),
                                ),
                              ),
                              const Padding(
                                padding: EdgeInsets.symmetric(horizontal: 8.0),
                                child: Icon(
                                  Icons.chevron_right,
                                  color: AppColors.unSelectedColor,
                                ),
                              ),
                            ],
                          ),
                        ),
                      ),
                    ],
                  ),
                );
              },
              separatorBuilder: (context, index) => const Divider(
                    height: 1.0,
                    color: Color(0XFFCACACA),
                  ),
              itemCount: FinesManual.categories.length),
        ),
      ],
    );
  }
}
