import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';
import 'package:modal_progress_hud_nsn/modal_progress_hud_nsn.dart';
import 'package:road24_mobile/data/repository/FinesRepository.dart';
import 'package:road24_mobile/data/response/manual_part/fines/FinesManualResponse.dart';
import 'package:road24_mobile/model/blocs/fines/fines_bloc.dart';
import 'package:road24_mobile/model/mixins/FinesManualMixin.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/manual/parts/fines/articles.dart';
import 'package:road24_mobile/view/manual/parts/fines/thematics.dart';
import 'package:road24_mobile/view/widgets/no_connection_screen.dart';
import 'package:sizer/sizer.dart';

import '../../../../my_app.dart';

class FinesManual extends StatefulWidget {
  static int? basicCalculationAmount;
  static List<Articles> articles = [];
  static List parts = [];
  static List<Categories> categories = [];

  const FinesManual({Key? key}) : super(key: key);

  @override
  _FinesManualState createState() => _FinesManualState();
}

class _FinesManualState extends State<FinesManual>
    with SingleTickerProviderStateMixin, FinesManualMixin {
  late TabController controller;

  int _activeTab = 0;

  var fineBloc = FinesBloc(repository: FinesRepository());

  bool loading = false;

  @override
  void initState() {
    fineBloc.add(GetCategories());

    // fineBloc.add(GetArticles());

    controller = TabController(
      initialIndex: 0,
      length: 2,
      vsync: this,
    );

    controller
      ..addListener(() {
        setState(() {
          _activeTab = controller.index;
        });
      });

    super.initState();
  }

  @override
  void dispose() {
    controller.dispose();
    fineBloc.close();
    super.dispose();
  }

  Widget _createTabForMain(String text, int index) {
    return Tab(
      child: Container(
        margin: const EdgeInsets.symmetric(horizontal: 5.0),
        padding: const EdgeInsets.symmetric(horizontal: 15.0),
        decoration: BoxDecoration(
          color: _activeTab == index ? Colors.white : Colors.transparent,
          borderRadius: BorderRadius.circular(100.0),
        ),
        child: Center(
          child: Text(
            text,
            style: TextStyle(
              color:
                  _activeTab == index ? Color(0xff000000) : Color(0xff747474),
              fontWeight:
                  _activeTab == index ? FontWeight.w600 : FontWeight.w500,
              fontSize: 15.0,
              height: 1.2,
              letterSpacing: 0.2,
            ),
            maxLines: 1,
          ),
        ),
      ),
    );
  }

  @override
  Widget build(BuildContext context) {
    return ValueListenableBuilder<bool>(
        valueListenable: MyApp.hasInternet,
        builder: (context, bool hasInternet, _) {
          if (hasInternet)
            return GestureDetector(
              onTap: () => FocusScope.of(context).unfocus(),
              child: ModalProgressHUD(
                inAsyncCall: loading,
                color: AppColors.unSelectedColor,
                progressIndicator: const CircularProgressIndicator(
                  strokeWidth: 3.0,
                  valueColor: AlwaysStoppedAnimation<Color>(
                    AppColors.unSelectedColor,
                  ),
                ),
                child: Scaffold(
                  backgroundColor: AppColors.appPrimaryColor,
                  appBar: AppBar(
                    toolbarHeight: 60.0,
                    leading: Material(
                      type: MaterialType.transparency,
                      child: InkWell(
                        onTap: () {
                          Navigator.pop(context);
                        },
                        child: Container(
                          margin: const EdgeInsets.all(10.0),
                          decoration: const BoxDecoration(
                            color: Color(0xffDFDFDF),
                            shape: BoxShape.circle,
                          ),
                          child: const Center(
                            child: Icon(
                              Icons.arrow_back_ios_outlined,
                              size: 20.0,
                              color: Colors.black,
                            ),
                          ),
                        ),
                      ),
                    ),
                    title: Text(
                      S.of(context).manual_fines,
                      style: AppStyle.textStyle().copyWith(
                          color: Colors.black,
                          fontWeight: FontWeight.w600,
                          fontSize: 21.0),
                      maxLines: 2,
                      textAlign: TextAlign.center,
                    ),
                  ),
                  body: BlocBuilder(
                      bloc: fineBloc,
                      builder: (context, state) {
                        // List<Categories> categories = [];

                        // List<Articles> articles = [];

                        // if (state is FineInfoSuccessState) {
                        //   FinesManual.categories.clear();

                        //   FinesManual.categories.addAll(state.categories);

                        //   FinesManual.articles.clear();

                        //   FinesManual.articles.addAll(state.articles);

                        //   FinesManual.articles.sort((a, b) => a.id.compareTo(b.id));
                        // }
                        return (state is LoadingState)
                            ? const Center(child: CircularProgressIndicator())
                            : Container(
                                margin: const EdgeInsets.symmetric(
                                    horizontal: 16.0),
                                width: 100.0.w,
                                child: Column(
                                  crossAxisAlignment: CrossAxisAlignment.center,
                                  children: [
                                    const SizedBox(height: 20.0),
                                    Container(
                                      height: 50.0,
                                      padding: const EdgeInsets.symmetric(
                                          vertical: 5.0),
                                      decoration: BoxDecoration(
                                        color:
                                            Color(0xff767680).withOpacity(0.12),
                                        borderRadius:
                                            BorderRadius.circular(100.0),
                                      ),
                                      child: TabBar(
                                        isScrollable: false,
                                        controller: controller,
                                        indicatorColor: Colors.transparent,
                                        labelPadding: EdgeInsets.symmetric(
                                            horizontal: 0.0),
                                        tabs: <Widget>[
                                          _createTabForMain(
                                              "${S.of(context).thematics}", 0),
                                          _createTabForMain(
                                              "${S.of(context).all_articles}",
                                              1),
                                        ],
                                      ),
                                    ),
                                    const SizedBox(height: 10.0),
                                    Expanded(
                                      child: TabBarView(
                                        physics:
                                            const NeverScrollableScrollPhysics(),
                                        controller: controller,
                                        children: <Widget>[
                                          Thematics(),
                                          ArticlesPage(
                                            articles: FinesManual.articles,
                                          ),
                                        ],
                                      ),
                                    )
                                  ],
                                ),
                              );
                      }),
                ),
              ),
            );
          else
            return NoConnectionScreen(
                // message: S.of(context).check_connection,
                onTap: () {
              fineBloc.add(GetCategories());
            });
        });
  }
}
