import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:road24_mobile/data/repository/FinesRepository.dart';
import 'package:road24_mobile/data/response/manual_part/fines/FinesManualResponse.dart';
import 'package:road24_mobile/model/blocs/fines/fines_bloc.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/manual/parts/fines/fines_manual.dart';

import 'package:road24_mobile/utils/extensions.dart';
import 'package:road24_mobile/view/widgets/no_connection_screen.dart';
import '../../../../../my_app.dart';
import 'article_detail.dart';

class ThematicDetails extends StatefulWidget {
  final Categories category;

  const ThematicDetails({
    Key? key,
    required this.category,
  }) : super(key: key);

  @override
  _ThematicDetailsState createState() => _ThematicDetailsState();
}

class _ThematicDetailsState extends State<ThematicDetails> {
  List<Articles> articlesToShow = [];

  var fineBloc = FinesBloc(repository: FinesRepository());

  @override
  void initState() {
    getData();
    super.initState();
  }

  @override
  void dispose() {
    fineBloc.close();
    super.dispose();
  }

  getData() {
    var articlesId = widget.category.articleId.split(",");
    articlesToShow.addAll(FinesManual.articles
        .where((article) => articlesId.contains(article.id.toString())));
  }

  @override
  Widget build(BuildContext context) {
    return ValueListenableBuilder<bool>(
        valueListenable: MyApp.hasInternet,
        builder: (context, bool hasInternet, _) {
          print("hasinternet...$hasInternet");
          if (hasInternet)
            return Scaffold(
              backgroundColor: AppColors.appPrimaryColor,
              appBar: appBar(context),
              body: Padding(
                padding: const EdgeInsets.symmetric(horizontal: 16.0),
                child: Column(
                  crossAxisAlignment: CrossAxisAlignment.start,
                  children: [
                    Padding(
                      padding: const EdgeInsets.all(3.0),
                      child: Text(
                        widget.category.articleCategories,
                        style: AppStyle.textStyle().copyWith(
                            color: Color(0xff282828),
                            fontSize: 24.0,
                            fontWeight: FontWeight.w700),
                      ),
                    ),
                    const SizedBox(height: 10.0),
                    Expanded(
                        child: ListView.separated(
                            itemCount: articlesToShow.length,
                            separatorBuilder: (context, index) => const Divider(
                                  height: 1.0,
                                  color: Color(0XFFCACACA),
                                ),
                            itemBuilder: (context, index) {
                              String textToShow = articlesToShow[index]
                                  .number
                                  .getUnicodedText();

                              return Container(
                                height: 72.0,
                                child: Column(
                                  mainAxisAlignment:
                                      MainAxisAlignment.spaceAround,
                                  crossAxisAlignment: CrossAxisAlignment.start,
                                  children: [
                                    InkWell(
                                      onTap: () {
                                        Navigator.push(
                                          context,
                                          CupertinoPageRoute(
                                            builder: (context) =>
                                                ArticleDetails(
                                              articleNumber:
                                                  articlesToShow[index].number,
                                              articleName:
                                                  articlesToShow[index].title,
                                              url: articlesToShow[index].url,
                                              articleId:
                                                  articlesToShow[index].id,
                                            ),
                                          ),
                                        );
                                      },
                                      child: Row(
                                        mainAxisAlignment:
                                            MainAxisAlignment.spaceBetween,
                                        children: [
                                          Expanded(
                                            flex: 1,
                                            child: Container(
                                              width: 40.0,
                                              height: 40.0,
                                              decoration: BoxDecoration(
                                                shape: BoxShape.circle,
                                                color: AppColors.colore8e8e8,
                                              ),
                                              child: Center(
                                                child: Text(
                                                  textToShow,
                                                  style: AppStyle.textStyle()
                                                      .copyWith(
                                                    color: Color(0xff282828),
                                                    fontSize: 16.0,
                                                    fontWeight: FontWeight.w400,
                                                  ),
                                                ),
                                              ),
                                            ),
                                          ),
                                          Expanded(
                                            flex: 5,
                                            child: Padding(
                                              padding:
                                                  const EdgeInsets.symmetric(
                                                      horizontal: 5.0),
                                              child: Text(
                                                articlesToShow[index].title,
                                                maxLines: 3,
                                                style: AppStyle.textStyle()
                                                    .copyWith(
                                                        color:
                                                            Color(0xff282828),
                                                        fontWeight:
                                                            FontWeight.w400,
                                                        fontSize: 16.0),
                                              ),
                                            ),
                                          ),
                                          const Expanded(
                                            flex: 1,
                                            child: Padding(
                                              padding: EdgeInsets.symmetric(
                                                  horizontal: 8.0),
                                              child: Icon(
                                                Icons.chevron_right,
                                                color:
                                                    AppColors.unSelectedColor,
                                              ),
                                            ),
                                          ),
                                        ],
                                      ),
                                    ),
                                  ],
                                ),
                              );
                            })),
                  ],
                ),
              ),
            );
          else
            return NoConnectionScreen(onTap: () {
              getData();
            });
        });
  }

  AppBar appBar(BuildContext context) {
    return AppBar(
      toolbarHeight: 60.0,
      leading: Material(
        type: MaterialType.transparency,
        child: InkWell(
          onTap: () {
            Navigator.pop(context);
          },
          child: Container(
            margin: const EdgeInsets.all(10.0),
            decoration: BoxDecoration(
              color: Color(0xffDFDFDF),
              shape: BoxShape.circle,
            ),
            child: const Center(
              child: Icon(
                Icons.arrow_back_ios_outlined,
                size: 20.0,
                color: Colors.black,
              ),
            ),
          ),
        ),
      ),
      title: Text(
        S.of(context).manual_fines,
        style: AppStyle.textStyle().copyWith(
            color: Colors.black, fontWeight: FontWeight.w600, fontSize: 21.0),
        maxLines: 2,
        textAlign: TextAlign.center,
      ),
    );
  }
}
