import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:road24_mobile/data/response/manual_part/fines/FinesManualResponse.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/utils/extensions.dart';
import 'details/article_detail.dart';

class ArticlesPage extends StatelessWidget {
  final List<Articles> articles;

  const ArticlesPage({Key? key, required this.articles}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Column(
      crossAxisAlignment: CrossAxisAlignment.start,
      children: [
        Padding(
          padding: const EdgeInsets.all(3.0),
          child: Text(
            S.of(context).all_articles,
            style: AppStyle.textStyle().copyWith(
                color: Color(0xff282828),
                fontSize: 24.0,
                fontWeight: FontWeight.w700),
          ),
        ),
        const SizedBox(height: 10.0),
        Expanded(
          child: ListView.builder(
              shrinkWrap: true,
              itemCount: articles.length,
              itemBuilder: (context, index) {
                String textToShow = articles[index].number.getUnicodedText();

                return Container(
                  height: 72.0,
                  child: Column(
                    mainAxisAlignment: MainAxisAlignment.spaceAround,
                    crossAxisAlignment: CrossAxisAlignment.start,
                    children: [
                      Expanded(
                        child: InkWell(
                          // padding: EdgeInsets.zero,
                          onTap: () {
                            Navigator.push(
                              context,
                              CupertinoPageRoute(
                                builder: (context) => ArticleDetails(
                                  articleNumber: articles[index].number,
                                  articleName: articles[index].title,
                                  url: articles[index].url,
                                  articleId: articles[index].id,
                                ),
                              ),
                            );
                          },
                          child: Row(
                            mainAxisAlignment: MainAxisAlignment.spaceBetween,
                            children: [
                              Expanded(
                                flex: 1,
                                child: Container(
                                  width: 40.0,
                                  height: 40.0,
                                  decoration: const BoxDecoration(
                                    shape: BoxShape.circle,
                                    color: AppColors.colore8e8e8,
                                  ),
                                  child: Center(
                                    child: Text(
                                      textToShow,
                                      style: AppStyle.textStyle().copyWith(
                                        color: Color(0xff282828),
                                        fontSize: 16.0,
                                        fontWeight: FontWeight.w400,
                                      ),
                                    ),
                                  ),
                                ),
                              ),
                              Expanded(
                                flex: 5,
                                child: Padding(
                                  padding: const EdgeInsets.symmetric(
                                      horizontal: 5.0),
                                  child: Text(
                                    articles[index].title,
                                    maxLines: 3,
                                    overflow: TextOverflow.ellipsis,
                                    style: AppStyle.textStyle().copyWith(
                                        color: Color(0xff282828),
                                        fontWeight: FontWeight.w400,
                                        fontSize: 16.0),
                                  ),
                                ),
                              ),
                              const Expanded(
                                flex: 1,
                                child: Padding(
                                  padding:
                                      EdgeInsets.symmetric(horizontal: 8.0),
                                  child: Icon(
                                    Icons.chevron_right,
                                    color: AppColors.unSelectedColor,
                                  ),
                                ),
                              ),
                            ],
                          ),
                        ),
                      ),
                      (index != 9)
                          ? const Divider(
                              height: 1.0,
                              color: Color(0XFFCACACA),
                            )
                          : const SizedBox()
                    ],
                  ),
                );
              }),
        ),
      ],
    );
  }
}
