import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/manual/parts/faq.dart';
import 'package:road24_mobile/view/manual/parts/fines/fines_manual.dart';
import 'package:road24_mobile/view/manual/parts/inspection/inspection_manual.dart';
import 'package:road24_mobile/view/manual/parts/signes%20and%20rules%20manual/signes_and_rules_manual.dart';
import 'package:road24_mobile/view/widgets/items/manual_item.dart';

class Manual extends StatelessWidget {
  const Manual({Key? key}) : super(key: key);

  @override
  Widget build(BuildContext context) {
    bool isSnackBarActive = false;
    return Container(
      padding: const EdgeInsets.symmetric(horizontal: 16.0),
      child: ListView(
        shrinkWrap: true,
        children: [
          const SizedBox(height: 15.0),
          Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              Expanded(
                child: ManualItem(
                  title: S.of(context).manual_fines,
                  onTap: () {
                    Navigator.push(
                      context,
                      CupertinoPageRoute(builder: (context) => FinesManual()),
                    );
                  },
                  svgIconPath: "assets/svg/manual_fines.svg",
                ),
              ),
              const SizedBox(width: 15.0),
              Expanded(
                child: ManualItem(
                  title: S.of(context).manual_inspection,
                  onTap: () {
                    Navigator.push(
                      context,
                      CupertinoPageRoute(
                          builder: (context) => InspectionManual()),
                    );
                  },
                  svgIconPath: "assets/svg/manual_inspection.svg",
                ),
              ),
            ],
          ),
          const SizedBox(height: 15.0),
          Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              Expanded(
                child: ManualItem(
                  title: S.of(context).manual_signes_and_rules,
                  onTap: () {
                    Navigator.push(
                      context,
                      CupertinoPageRoute(
                          builder: (context) => SignesAndRulesManual()),
                    );
                  },
                  svgIconPath: "assets/svg/manual_signes_and_rules.svg",
                ),
              ),
              const SizedBox(width: 15.0),
              Expanded(
                child: ManualItem(
                  title: S.of(context).manual_shopping,
                  onTap: () {
                    if (!isSnackBarActive) {
                      isSnackBarActive = true;
                      Duration snackBarDuration = Duration(milliseconds: 3500);
                      ScaffoldMessenger.of(context).showSnackBar(
                        SnackBar(
                          content: Text(S.of(context).soon),
                          duration: snackBarDuration,
                          backgroundColor: AppColors.selectedColor,
                        ),
                      );
                      Future.delayed(snackBarDuration)
                          .then((value) => isSnackBarActive = false);
                    }
                    // Navigator.push(
                    //   context,
                    //   CupertinoPageRoute(builder: (context) => ShoppingManual()),
                    // );
                  },
                  svgIconPath: "assets/svg/manual_shopping.svg",
                ),
              ),
            ],
          ),
          const SizedBox(height: 15.0),
          Row(
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              Expanded(
                child: ManualItem(
                  title: S.of(context).manual_refactor_car,
                  onTap: () {
                    if (!isSnackBarActive) {
                      isSnackBarActive = true;
                      Duration snackBarDuration = Duration(milliseconds: 3500);
                      ScaffoldMessenger.of(context).showSnackBar(
                        SnackBar(
                          content: Text(S.of(context).soon),
                          duration: snackBarDuration,
                          backgroundColor: AppColors.selectedColor,
                        ),
                      );
                      Future.delayed(snackBarDuration)
                          .then((value) => isSnackBarActive = false);
                    }
                  },
                  svgIconPath: "assets/svg/manual_refactor.svg",
                ),
              ),
              const SizedBox(width: 15.0),
              Expanded(
                child: ManualItem(
                  title: S.of(context).manual_FAQ,
                  onTap: () {
                    // if (!isSnackBarActive) {
                    //   isSnackBarActive = true;
                    //   Duration snackBarDuration =
                    //       Duration(milliseconds: 3500);
                    //   ScaffoldMessenger.of(context).showSnackBar(
                    //     SnackBar(
                    //       content: Text(S.of(context).soon),
                    //       duration: snackBarDuration,
                    //       backgroundColor: AppColors.selectedColor,
                    //     ),
                    //   );
                    //   Future.delayed(snackBarDuration)
                    //       .then((value) => isSnackBarActive = false);
                    // }
                    Navigator.push(
                      context,
                      CupertinoPageRoute(builder: (context) => FAQ()),
                    );
                  },
                  svgIconPath: "assets/svg/manual_faq.svg",
                ),
              ),
            ],
          ),
          const SizedBox(height: 15.0),
        ],
      ),
    );
  }
}
