import 'package:flutter/material.dart';
import 'package:flutter_svg/flutter_svg.dart';
import 'package:road24_mobile/model/utils/Config.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:sizer/sizer.dart';

class LanguageButton extends StatelessWidget {
  final String text;
  final String assetsImgUrl;
  final String langCode;
  final ValueChanged<String>? onPressed;

  const LanguageButton({
    required this.assetsImgUrl,
    required this.text,
    required this.langCode,
    this.onPressed,
  });

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: EdgeInsets.symmetric(horizontal: 5.0.w, vertical: 1.0.h),
      child: MaterialButton(
        height: 10.0.w,
        onPressed: onPressed != null ? () => onPressed!(langCode) : null,
        padding: EdgeInsets.all(2.0.w),
        color: AppColors.appPrimaryColor,
        elevation: 0,
        shape: RoundedRectangleBorder(
          borderRadius: BorderRadius.circular(4.0.w),
        ),
        child: Row(
          mainAxisAlignment: MainAxisAlignment.center,
          children: [
            SvgPicture.asset(assetsImgUrl, width: 8.0.w),
            const Spacer(),
            Text(
              text,
              style: TextStyle(fontSize: 15.0.sp, fontWeight: FontWeight.w500),
            ),
            const Spacer(),
            Icon(
              Icons.check_circle_outlined,
              color: Config.language == langCode
                  ? AppColors.selectedColor
                  : Colors.transparent,
            )
          ],
        ),
      ),
    );
  }
}
