import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/base/splash/splash_screen.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:sizer/sizer.dart';

class LanguageBottom extends StatelessWidget {
  const LanguageBottom({Key? key}) : super(key: key);
  @override
  Widget build(BuildContext context) {
    return Container(
      padding: EdgeInsets.all(4.0.w),
      child: Column(
        mainAxisAlignment: MainAxisAlignment.end,
        children: [
          Text(
            SplashScreen.packageInfo == null
                ? ""
                : "${S.of(context).version} v${SplashScreen.packageInfo!.version}",
            // (${SplashScreen.packageInfo!.buildNumber})",
            style: AppStyle.textStyle().copyWith(
                color: Color(0xFF959595),
                fontWeight: FontWeight.w500,
                fontSize: 14.0),
            textAlign: TextAlign.center,
          ),
          Text(
            "© IIV YHXBB, ${DateTime.now().year}",
            style: AppStyle.textStyle().copyWith(
                color: Color(0xFF959595),
                fontWeight: FontWeight.w500,
                fontSize: 14.0),
            textAlign: TextAlign.center,
          ),
        ],
      ),
    );
  }
}
