import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:modal_progress_hud_nsn/modal_progress_hud_nsn.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/view/auth/phone_page.dart';
import 'package:sizer/sizer.dart';
import 'package:road24_mobile/model/utils/Config.dart';
import 'widgets/widgets.dart';

class LanguageChoose extends StatefulWidget {
  @override
  _LanguageChooseState createState() => _LanguageChooseState();
}

class _LanguageChooseState extends State<LanguageChoose> {
  bool loading = false;

  Future<void> onChangedLanguage(String langCode) async {
    setState(() => loading = true);
    setState(() => Config.language = langCode);
    await Future.delayed(Duration(milliseconds: 600));
    await Config.onAppLanguageChanged(Config.language);
    await Config.setLanguageToSharedPrefs(Config.language);
    setState(() => loading = false);
    await Navigator.push(
      context,
      CupertinoPageRoute(builder: (_) => PhonePage()),
    );
  }

  @override
  Widget build(BuildContext context) {
    return ModalProgressHUD(
      inAsyncCall: loading,
      progressIndicator: const CircularProgressIndicator(
        strokeWidth: 3.0,
        valueColor: AlwaysStoppedAnimation(AppColors.unSelectedColor),
      ),
      child: Scaffold(
        backgroundColor: Colors.white,
        body: SafeArea(
          child: Column(
            mainAxisAlignment: MainAxisAlignment.spaceBetween,
            children: <Widget>[
              Expanded(
                flex: 4,
                child: Column(
                  mainAxisAlignment: MainAxisAlignment.center,
                  children: [
                    const LanguageLogo(),
                    SizedBox(height: 3.0.h),
                    const LanguageTitle(),
                    SizedBox(height: 2.0.h),
                    LanguageButton(
                      assetsImgUrl: 'assets/svg/uzb.svg',
                      text: "O'zbek",
                      langCode: 'oz',
                      onPressed: (value) async =>
                          await onChangedLanguage(value),
                    ),
                    LanguageButton(
                      assetsImgUrl: 'assets/svg/rus.svg',
                      text: "Русский",
                      langCode: 'ru',
                      onPressed: (value) async =>
                          await onChangedLanguage(value),
                    ),
                    LanguageButton(
                      assetsImgUrl: 'assets/svg/uzb.svg',
                      text: "Ўзбекча",
                      langCode: 'uz',
                      onPressed: (value) async =>
                          await onChangedLanguage(value),
                    ),
                  ],
                ),
              ),
              const Expanded(child: LanguageBottom()),
            ],
          ),
        ),
      ),
    );
  }
}
