import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';

class UpdatePage extends StatelessWidget {
  final VoidCallback? onSkipped;
  final VoidCallback? onLaunched;
  final bool skipped;

  const UpdatePage({
    Key? key,
    required this.onSkipped,
    required this.onLaunched,
    required this.skipped,
  }) : super(key: key);

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Colors.transparent,
      body: Center(
        child: Container(
          width: double.infinity,
          margin: const EdgeInsets.all(32),
          padding: const EdgeInsets.only(top: 16),
          decoration: BoxDecoration(
            color: Colors.white,
            borderRadius: BorderRadius.circular(16),
          ),
          child: Column(
            mainAxisSize: MainAxisSize.min,
            mainAxisAlignment: MainAxisAlignment.center,
            children: [
              Padding(
                padding: const EdgeInsets.symmetric(horizontal: 32),
                child: Text(
                  S.of(context).update,
                  textAlign: TextAlign.center,
                  style: AppStyle.textStyle().copyWith(
                    fontSize: 20,
                    color: AppColors.selectedColor,
                  ),
                ),
              ),
              const SizedBox(height: 16),
              Container(
                  width: double.infinity, height: 1, color: Colors.grey[200]),
              SizedBox(
                height: 50,
                child: Row(
                  children: [
                    !skipped
                        ? const SizedBox()
                        : Expanded(
                            child: CupertinoButton(
                              padding: EdgeInsets.all(0),
                              child: Text(S.of(context).skip),
                              onPressed: () {
                                if (onSkipped != null) onSkipped!();
                              },
                            ),
                          ),
                    !skipped
                        ? const SizedBox()
                        : Container(
                            width: 1,
                            height: double.infinity,
                            color: Colors.grey[200]),
                    Expanded(
                      child: CupertinoButton(
                        padding: EdgeInsets.all(0),
                        child: Text(S.of(context).refresh),
                        onPressed: () {
                          if (onLaunched != null) onLaunched!();
                        },
                      ),
                    ),
                  ],
                ),
              ),
            ],
          ),
        ),
      ),
    );
  }
}
