import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/Config.dart';
import 'package:road24_mobile/view/built/i18n.dart';

class AppTranslationsDelegate extends GeneratedLocalizationsDelegate {
  @override
  bool shouldReload(GeneratedLocalizationsDelegate old) => true;

  @override
  Future<S> load(Locale? locale) {
    if (Config.language != "") {
      switch (Config.language) {
        case "ru":
          return SynchronousFuture<S>(const $ru());
        case "uz":
          return SynchronousFuture<S>(const $uz());
        case "oz":
          return SynchronousFuture<S>(const $oz());
        default:
      }
    }

    return SynchronousFuture<S>(const S());
  }
}
