import 'package:flutter/material.dart';
import 'package:flutter/cupertino.dart';
import 'package:mask_text_input_formatter/mask_text_input_formatter.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/auth/sms_verification_page.dart';
import 'package:road24_mobile/view/base/splash/splash_screen.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/widgets/custom_button.dart';
import 'package:road24_mobile/view/widgets/custom_text_field.dart';
import 'package:sizer/sizer.dart';
import 'package:url_launcher/url_launcher.dart';

class PhonePage extends StatefulWidget {
  final bool isSkipped;

  const PhonePage({Key? key, this.isSkipped = true}) : super(key: key);

  @override
  _SearchAddressPageState createState() => _SearchAddressPageState();
}

class _SearchAddressPageState extends State<PhonePage> {
  final phoneController = TextEditingController();
  bool isValid = false;

  @override
  void dispose() {
    phoneController.dispose();
    super.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return GestureDetector(
      onTap: () {
        FocusScope.of(context).requestFocus(new FocusNode());
      },
      child: Scaffold(
        backgroundColor: Color(0xffF9F9F9),
        body: SingleChildScrollView(
          child: Container(
            height: 100.0.h,
            child: SafeArea(
              child: Column(
                crossAxisAlignment: CrossAxisAlignment.start,
                mainAxisAlignment: MainAxisAlignment.end,
                children: [
                  Expanded(
                    flex: 2,
                    child: Column(
                      crossAxisAlignment: CrossAxisAlignment.start,
                      mainAxisAlignment: MainAxisAlignment.start,
                      children: [
                        SizedBox(height: 8.0.h),
                        Padding(
                          padding: EdgeInsets.symmetric(vertical: 2.0.h),
                          child: Image.asset(
                            "assets/png/auth_mobile_img.png",
                            height: 12.0.h,
                            fit: BoxFit.fitHeight,
                          ),
                        ),
                        SizedBox(height: 2.0.h),
                        Padding(
                          padding: EdgeInsets.symmetric(horizontal: 4.0.w),
                          child: Text(
                            "${S.of(context).authorization}",
                            style: AppStyle.textStyle().copyWith(
                              fontWeight: FontWeight.bold,
                              fontSize: 24.0,
                              color: Color(0xff282828),
                            ),
                          ),
                        ),
                        SizedBox(height: 2.0.h),
                        Padding(
                          padding: EdgeInsets.symmetric(horizontal: 4.0.w),
                          child: Text(
                            "${S.of(context).enter_phone_number}",
                            style: AppStyle.textStyle().copyWith(
                                color: Color(0xFF959595),
                                fontWeight: FontWeight.normal,
                                fontSize: 14.0),
                          ),
                        ),
                        Padding(
                          padding: EdgeInsets.symmetric(
                            horizontal: 4.0.w,
                            vertical: 1.0.w,
                          ),
                          child: CustomTextField(
                            inputType: TextInputType.phone,
                            controller: phoneController,
                            prefix: "+998(",
                            mask: MaskTextInputFormatter(
                              initialText: phoneController.text,
                              mask: '__) ___-__-__',
                              filter: {"_": RegExp(r'[0-9]')},
                            ),
                            text: "__) ___-__-__",
                            style: AppStyle.textStyle().copyWith(
                              fontWeight: FontWeight.w500,
                              fontSize: 16.0,
                              color: Color(0xff282828),
                            ),
                          ),
                        ),
                        Padding(
                          padding: EdgeInsets.symmetric(
                              horizontal: 4.0.w, vertical: 10.0),
                          child: CustomButton(
                            title: S.of(context).done,
                            onTap: () async {
                              print(phoneController.text.length);
                              if (phoneController.text.length == 13) {
                                // await FirebaseNotifications
                                //     .requestNotificationPermission();
                                Navigator.push(
                                  context,
                                  CupertinoPageRoute(
                                    builder: (context) {
                                      return SmsVerificationPage(
                                        phoneNumber: "998" +
                                            phoneController.text
                                                .toString()
                                                .replaceAll(" ", "")
                                                .replaceAll("(", "")
                                                .replaceAll(")", "")
                                                .replaceAll("-", ""),
                                      );
                                    },
                                  ),
                                );
                              }
                            },
                          ),
                        ),
                      ],
                    ),
                  ),
                  Expanded(
                    flex: 1,
                    child: Container(
                      width: 100.0.w,
                      child: Column(
                        mainAxisAlignment: MainAxisAlignment.spaceBetween,
                        crossAxisAlignment: CrossAxisAlignment.center,
                        children: [
                          InkWell(
                            onTap: () async {
                              await launch('https://road24.uz/privacy-policy/');
                            },
                            child: Padding(
                              padding: EdgeInsets.symmetric(horizontal: 3.0.w),
                              child: Text(
                                "${S.of(context).by_entering_phone_number}",
                                textAlign: TextAlign.center,
                                style: AppStyle.textStyle().copyWith(
                                  fontWeight: FontWeight.normal,
                                  fontSize: 13.0,
                                  decoration: TextDecoration.underline,
                                  color: Color(0xFF959595),
                                ),
                              ),
                            ),
                          ),
                          Container(
                            padding: EdgeInsets.all(4.0.w),
                            child: Column(
                              children: [
                                Text(
                                  SplashScreen.packageInfo == null
                                      ? ""
                                      : "${S.of(context).version} v${SplashScreen.packageInfo?.version}",
                                  // (${SplashScreen.packageInfo?.buildNumber})",
                                  style: AppStyle.textStyle().copyWith(
                                      color: Color(0xFF959595),
                                      fontWeight: FontWeight.w500,
                                      fontSize: 14.0),
                                  textAlign: TextAlign.center,
                                ),
                                Text(
                                  "© IIV YHXBB, ${DateTime.now().year}",
                                  style: AppStyle.textStyle().copyWith(
                                      color: Color(0xFF959595),
                                      fontWeight: FontWeight.w500,
                                      fontSize: 14.0),
                                  textAlign: TextAlign.center,
                                ),
                              ],
                            ),
                          ),
                        ],
                      ),
                    ),
                  ),
                ],
              ),
            ),
          ),
        ),
      ),
    );
  }
}
