import 'dart:ui';
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/rendering.dart';
import 'package:flutter/widgets.dart';
import 'package:road24_mobile/model/utils/styles/AppStyles.dart';
import 'package:road24_mobile/view/built/i18n.dart';
import 'package:road24_mobile/view/home/dash_board.dart';
import 'package:road24_mobile/view/mycar/add/add_new_car_first_step.dart';
import 'package:road24_mobile/view/widgets/custom_bottom_tabbar.dart';
import 'package:road24_mobile/view/widgets/custom_button.dart';

class AuthSuccessPage extends StatelessWidget {
  @override
  Widget build(BuildContext context) {
    return Scaffold(
      backgroundColor: Color(0xffF9F9F9),
      body: SingleChildScrollView(
        child: Column(
          crossAxisAlignment: CrossAxisAlignment.start,
          children: [
            Image.asset(
              "assets/png/hello_thumb.png",
              scale: 1.2,
            ),
            Padding(
              padding: const EdgeInsets.symmetric(horizontal: 20.0),
              child: Column(
                mainAxisAlignment: MainAxisAlignment.start,
                crossAxisAlignment: CrossAxisAlignment.start,
                children: [
                  Text(
                    "${S.of(context).welcome_to_road24}",
                    style: AppStyle.textStyle().copyWith(
                      fontSize: 24.0,
                      fontWeight: FontWeight.bold,
                      color: Color(0xff282828),
                    ),
                    maxLines: 2,
                    overflow: TextOverflow.ellipsis,
                  ),
                  const SizedBox(height: 10.0),
                  Text(
                    "${S.of(context).you_need_car_number}",
                    style: AppStyle.textStyle().copyWith(
                        color: Color(0xff747474),
                        fontWeight: FontWeight.normal,
                        fontSize: 15.0),
                  ),
                  const SizedBox(height: 20.0),
                  CustomButton(
                    color: Color(0xffDCDCDC),
                    onTap: () {
                      DashBoard.activeTab.value =
                          CustomBottomTabBar.indexMap['MyAvto'];
                      Navigator.pushReplacement(
                        context,
                        CupertinoPageRoute(
                          builder: (context) {
                            return AddNewCarFirstStep(
                              isFromRegistrationPage: true,
                            );
                            // return AddNewCarOrEditPage(
                            //   isFromRegistrationPage: true,
                            // );
                          },
                        ),
                      );
                    },
                    title: "${S.of(context).go}",
                    textStyle: AppStyle.textStyle().copyWith(
                        color: Color(0xff333333),
                        fontWeight: FontWeight.w600,
                        fontSize: 16.0),
                  ),
                  const SizedBox(height: 20.0),
                ],
              ),
            ),
          ],
        ),
      ),
    );
  }
}
