import 'package:flick_video_player/flick_video_player.dart';
import 'package:flutter/material.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:video_player/video_player.dart';

class VideoItems extends StatefulWidget {
  final VideoPlayerController videoPlayerController;
  final bool looping;
  final bool autoplay;

  VideoItems({
    required this.videoPlayerController,
    this.looping = false,
    this.autoplay = false,
    Key? key,
  }) : super(key: key);

  @override
  _VideoItemsState createState() => _VideoItemsState();
}

class _VideoItemsState extends State<VideoItems> {
  late FlickManager flickManager;

  @override
  void initState() {
    super.initState();
    print("url   ${widget.videoPlayerController.dataSource}");
    flickManager = FlickManager(
      autoPlay: false,
      videoPlayerController: VideoPlayerController.network(
          widget.videoPlayerController.dataSource),
    );
  }

  @override
  void dispose() {
    super.dispose();
    flickManager.dispose();
    widget.videoPlayerController.dispose();
  }

  @override
  Widget build(BuildContext context) {
    return Container(
      decoration: BoxDecoration(
        borderRadius: BorderRadius.circular(3.0),
        border: Border.all(color: AppColors.color333333, width: 1.0),
      ),
      padding: const EdgeInsets.fromLTRB(2, 0, 2, 8),
      margin: EdgeInsets.only(bottom: 8),
      child: FlickVideoPlayer(flickManager: flickManager),
    );
  }
}
