import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_local_notifications/flutter_local_notifications.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:road24_mobile/model/utils/Config.dart';
import 'package:road24_mobile/model/utils/styles/AppColors.dart';
import 'package:road24_mobile/view/base/splash/splash_screen.dart';
import 'package:sizer/sizer.dart';
import 'data/shared_data.dart';
import 'view/base/app_translation_delegate.dart' as AppTranslationsDelegate;

class MyApp extends StatefulWidget {
  static ValueNotifier<bool> hasInternet = ValueNotifier(true);
  static Preferences? preferences;
  static GlobalKey<NavigatorState> navigatorKey = GlobalKey();
  static late BuildContext context;

  static var flutterLocalNotificationsPlugin =
      FlutterLocalNotificationsPlugin();

  static crashTokenSimulation() async {
    await Future.delayed(Duration(seconds: 4));
    preferences?.setToken("1");
  }

  @override
  _MyAppState createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  // final String currentLanguage = Config.language ?? 'oz';
  final AppTranslationsDelegate.AppTranslationsDelegate
      _generatedLocalizationsDelegate =
      AppTranslationsDelegate.AppTranslationsDelegate();

  @override
  void initState() {
    super.initState();

    MyApp.context = context;

    Config.onAppLanguageChanged = _appLanguageChanged;

    sharedPreferencesGetInstanceAndMapInit();
  }

  void _appLanguageChanged(String language) async {
    if (MyApp.preferences == null) {
      MyApp.preferences = await Preferences.getInstance();
    }
    if (language == "") {
      Config.language = MyApp.preferences!.getAppLanguage();
    }
    setState(() {});
  }

  @override
  void dispose() {
    super.dispose();

    Preferences.closeHiveBox();

    MyApp.hasInternet.dispose();
  }

  void sharedPreferencesGetInstanceAndMapInit() async {
    if (MyApp.preferences == null) {
      MyApp.preferences = await Preferences.getInstance();
    }

    Config.language = MyApp.preferences!.getAppLanguage();

    Config.onAppLanguageChanged(Config.language);
  }

  @override
  Widget build(BuildContext context) {
    return LayoutBuilder(builder: (context, constraints) {
      // if (constraints.maxWidth > 600) {
      //   DashBoard.forTablet.value = true;
      // } else {
      //   DashBoard.forTablet.value = false;
      // }
      return OrientationBuilder(builder: (context, orientation) {
        SizerUtil.setScreenSize(constraints, orientation);
        return MaterialApp(
          navigatorKey: MyApp.navigatorKey,
          debugShowCheckedModeBanner: false,
          localizationsDelegates: [
            _generatedLocalizationsDelegate,
            GlobalMaterialLocalizations.delegate,
            GlobalWidgetsLocalizations.delegate,
            GlobalCupertinoLocalizations.delegate,
            DefaultCupertinoLocalizations.delegate
          ],
          supportedLocales: _generatedLocalizationsDelegate.supportedLocales,
          localeResolutionCallback: _generatedLocalizationsDelegate.resolution(
            fallback: new Locale("uz", ""),
          ),
          theme: ThemeData(
            fontFamily: 'SF Pro',
            accentColor: Color(0xffF9F9F9).withOpacity(0.0),
            appBarTheme: AppBarTheme(
              color: Colors.transparent,
              systemOverlayStyle: SystemUiOverlayStyle.dark,
              elevation: 0.0,
              iconTheme: IconThemeData(color: Colors.black),
              textTheme: TextTheme(
                headline6: TextStyle(
                  color: Colors.black,
                  fontSize: 17.0,
                  fontWeight: FontWeight.bold,
                ),
              ),
            ),
            iconTheme: IconThemeData(color: AppColors.selectedColor),
            platform: TargetPlatform.iOS,
            inputDecorationTheme: InputDecorationTheme(
              border: UnderlineInputBorder(
                borderSide: BorderSide(color: AppColors.borderColor),
              ),
            ),
          ),
          home: SplashScreen(),
          builder: (context, widget) {
            return MediaQuery(
              data: MediaQuery.of(context).copyWith(textScaleFactor: 1.0),
              child: widget!,
            );
          },
        );
      });
    });
  }
}
