import 'package:flutter/material.dart';
import 'package:road24_mobile/view/base/app_translation_delegate.dart';
import 'package:road24_mobile/my_app.dart';
import 'styles/AppColors.dart';

class Config {
  static const String baseApiUrl = 'https://api.road24.uz/api/mobile/v1/';
  static const String baseApiPublicUrl = 'https://api.road24.uz/api/public/v1/';
  static const String baseFilesApiUrl = 'https://api.road24.uz/api/public/v1/';

  static String language = "";
  static bool intro = true;
  static const String addressKey = 'address_key';
  static const String landmarkKey = 'landmark_key';
  static const String userPhoneNumber = 'user_phone_number';
  static const String userFirstName = 'user_first_name';
  static const String userLastName = 'user_last_name';
  static const String userTokenKey = 'user_token_key';
  static const String userTokenKeyForDirectus = 'user_token_key_for_directus';
  static const String userRefreshTokenKey = 'user_refresh_token_key';
  static const String userRefreshTokenKeyForDirectus =
      'user_refresh_token_key_for_directus';
  static const String userMessagingToken = 'user_firebase_token';
  static const String hasUserFullName = 'has_user_full_name';
  static const String imagePath = 'user_image_path';
  static const String emailKey = 'email_key';
  static const String genderKey = 'gender_key';
  static const String birthDateKey = 'birth_date_key';
  static late Function(String language) onAppLanguageChanged;
  static ValueNotifier<int> notificationsCountNotifier = ValueNotifier(0);
  static ValueNotifier<String> profileImagePath = ValueNotifier('');

  // static Map<String, MapType> mapType = {
  //   'Normal': MapType.normal,
  //   'Hybrid': MapType.hybrid,
  // };
  // static MapType currentMap;
  static ValueNotifier<String> currentMapString = ValueNotifier('');

  static set notificationCount(int value) {
    notificationsCountNotifier.value = value;
  }

  static set profileImagePathDetector(String value) {
    profileImagePath.value = value;
  }

  // static showSnackBar(String text, GlobalKey<ScaffoldState> scaffoldKey,
  //     {bool? isRed, Duration? duration}) {
  //   if (isRed == null) {
  //     isRed = true;
  //   }
  //   var snackBar = new SnackBar(
  //     content: Text(text),
  //     duration: duration ?? Duration(milliseconds: 2500),
  //     backgroundColor: (isRed) ? Color(0xffF51A51) : AppColors.selectedColor,
  //   );
  //   scaffoldKey.currentState!.showSnackBar(snackBar);
  // }

  static showSnackBar(BuildContext context, String text,
      {bool? isRed, Duration? duration}) {
    if (isRed == null) {
      isRed = true;
    }
    var snackBar = new SnackBar(
      content: Text(text),
      duration: duration ?? Duration(milliseconds: 2500),
      backgroundColor: (isRed) ? Color(0xffF51A51) : AppColors.selectedColor,
    );
    ScaffoldMessenger.of(context).showSnackBar(snackBar);
  }

  static Future<void> getLanguageFromSharedPrefs() async {
    language = MyApp.preferences?.getAppLanguage() ?? "";
    if (language != "") {
      if (Config.language == 'уз') {
        Config.language = 'oz';
        await MyApp.preferences?.setAppLanguage(Config.language);
      }
      AppTranslationsDelegate().load(null);
    }
    print('App  Language is $language');
  }

  static Future<void> setLanguageToSharedPrefs(String newLanguage) async {
    await MyApp.preferences?.setAppLanguage(newLanguage);
    Config.language = newLanguage;
    AppTranslationsDelegate().load(null);

    print('App  Language changed to => $language');
  }

  static setMap(String type) async {
    await MyApp.preferences?.setMapType(type);
    // currentMap = mapType[type];
    currentMapString.value = type;
  }
}
