import 'package:road24_mobile/model/models/ChatMessage.dart';
import 'package:road24_mobile/model/models/LivechatConfigModel.dart';

class RocketChatState {
  final String? name;
  final String? email;
  final String? departmentId;
  final bool? isLoading;
  final LivechatConfig? config;
  final bool? lastMsgSent;
  final String? errorMessage;
  final List<LivechatMessage?>? history;
  final bool? finished;
  final int? unreadMsgs;

  RocketChatState({
    this.name,
    this.email,
    this.departmentId,
    this.isLoading = false,
    this.config,
    this.lastMsgSent = false,
    this.errorMessage,
    this.history,
    this.finished = false,
    this.unreadMsgs = 0,
  });

  RocketChatState copyWith({
    String? name,
    String? email,
    String? departmentId,
    bool? isLoading,
    LivechatConfig? config,
    bool? lastMsgSent,
    bool? finished,
    String? errorMessage,
    List<LivechatMessage>? history,
    int? unreadMsgs,
  }) {
    return RocketChatState(
      name: name ?? this.name,
      email: email ?? this.email,
      departmentId: departmentId ?? this.departmentId,
      isLoading: isLoading ?? this.isLoading,
      finished: finished ?? this.finished,
      config: config ?? this.config,
      lastMsgSent: lastMsgSent,
      errorMessage: errorMessage,
      history: history ?? this.history,
      unreadMsgs: unreadMsgs ?? this.unreadMsgs,
    );
  }

  @override
  String toString() {
    return "state history....$history";
  }
}
