import 'package:flutter/material.dart';

class ReportModel extends ChangeNotifier {
  final TextEditingController carNumber;
  String law;
  String title;
  String reportDescription;
  var penalty;
  String imgString;

  ReportModel({
    required this.title,
    required this.penalty,
    required this.law,
    required this.carNumber,
    required this.reportDescription,
    required this.imgString,
  });

  static List<ValueNotifier<ReportModel>> list = [];
  static List<ValueNotifier<bool>> areCarNumberFieldsValid = [];
  static List<ValueNotifier<bool>> areDescriptionsFieldsValid = [];
  static num lat = 12.2;
  static num lang = 34.1;
  static String date = "";
  static num videoID = 0;
  static num extraVideoID = 0;
  static String? address;

  static changedModel(ValueNotifier<ReportModel> notifier) {
    notifier.notifyListeners();
  }

  static checkForValidation(int index) {
    ReportModel.areCarNumberFieldsValid[index].notifyListeners();
    ReportModel.areDescriptionsFieldsValid[index].notifyListeners();
  }
}
