class NotificationModel {
  final String title;
  final String body;
  final String objectID;
  final NotificationType notificationType;
  final DateTime dateTime;

  NotificationModel(
      {required this.title,
      required this.body,
      required this.objectID,
      required this.notificationType,
      required this.dateTime});

  factory NotificationModel.fromJson(dynamic json) {
    print(json);
    return NotificationModel(
        title: json["notification"]["title"] ?? "Undefined",
        body: json["notification"]["body"] ?? "Undefined",
        objectID: json["data"]["obj_id"],
        notificationType: typeParser[json["data"]["action"]]!,
        dateTime: (json["data"]["google.sent_time"] != null)
            ? DateTime.fromMillisecondsSinceEpoch(
                json["data"]["google.sent_time"])
            : DateTime.now());
  }
}

Map<String, NotificationType> typeParser = {
  "partial_paid_fine": NotificationType.PARTIAL_PAID_FINE,
  "completely_paid_fine": NotificationType.COMPLETELY_PAID_FINE,
  "new_fine": NotificationType.NEW_FINE,
  "report_reviewed": NotificationType.REPORT_REVIEWED,
  "offence_changed_status": NotificationType.OFFENCE_CHANGED_STATUS,
};

enum NotificationType {
  PARTIAL_PAID_FINE,
  COMPLETELY_PAID_FINE,
  NEW_FINE,
  REPORT_REVIEWED,
  OFFENCE_CHANGED_STATUS
}
