class LivechatConfig {
  Config? config;
  bool success;

  LivechatConfig({
    this.config,
    required this.success,
  });

  factory LivechatConfig.fromJson(Map<String, dynamic> json) {
    return LivechatConfig(
        config: json['config'] != null ? Config.fromJson(json['config']) : null,
        success: json['success']);
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    if (config != null) {
      data['config'] = config!.toJson();
    }
    data['success'] = success;
    return data;
  }

  @override
  String toString() {
    return "$config";
  }
}

class Config {
  bool enabled;
  Settings? settings;
  Theme? theme;
  Messages? messages;
  Survey? survey;
  List<Trigger>? triggers;
  List<Departments>? departments;
  Resources? resources;
  bool online;
  Guest? guest;
  // Room room;

  Config({
    required this.enabled,
    this.settings,
    this.theme,
    this.messages,
    this.survey,
    this.triggers,
    this.departments,
    this.resources,
    required this.online,
    this.guest,
    // this.room
  });

  factory Config.fromJson(Map<String, dynamic> json) {
    return Config(
        enabled: json['enabled'],
        settings: json['settings'] != null
            ? Settings.fromJson(json['settings'])
            : null,
        theme: json['theme'] != null ? Theme.fromJson(json['theme']) : null,
        messages: json['messages'] != null
            ? Messages.fromJson(json['messages'])
            : null,
        survey: json['survey'] != null ? Survey.fromJson(json['survey']) : null,
        // triggers: json['triggers'] != null
        //     ? (json['triggers'] as List)
        //         .map((e) => Trigger.fromJson(e)??null)
        //         .toList(),
        triggers: null,
        departments: (json['departments'] != null)
            ? (json['departments'] as List)
                .map((e) => Departments.fromJson(e))
                .toList()
            : null,
        resources: json['resources'] != null
            ? Resources.fromJson(json['resources'])
            : null,
        online: json['online'],
        guest: null);
    // room = Room.fromJson(json["room"]);
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['enabled'] = enabled;
    if (settings != null) {
      data['settings'] = settings!.toJson();
    }
    if (theme != null) {
      data['theme'] = theme!.toJson();
    }
    if (messages != null) {
      data['messages'] = messages!.toJson();
    }
    if (survey != null) {
      data['survey'] = survey!.toJson();
    }
    if (triggers != null) {
      data['triggers'] = triggers!.map((v) => v.toJson()).toList();
    }
    if (departments != null) {
      data['departments'] = departments!.map((v) => v.toJson()).toList();
    }
    if (resources != null) {
      data['resources'] = resources!.toJson();
    }
    data['online'] = online;
    if (guest != null) {
      data['guest'] = guest!.toJson();
    }
    // if (room != null) {
    //   data['room'] = room.toJson();
    // }
    return data;
  }

  @override
  String toString() {
    return "is online=>$online,  agent=>$settings";
  }
}

class Settings {
  bool registrationForm;
  bool allowSwitchingDepartments;
  bool nameFieldRegistrationForm;
  bool emailFieldRegistrationForm;
  bool displayOfflineForm;
  bool videoCall;
  bool fileUpload;
  String language;
  bool transcript;
  String historyMonitorType;
  bool forceAcceptDataProcessingConsent;
  bool showConnecting;
  bool agentHiddenInfo;

  Settings({
    required this.registrationForm,
    required this.allowSwitchingDepartments,
    required this.nameFieldRegistrationForm,
    required this.emailFieldRegistrationForm,
    required this.displayOfflineForm,
    required this.videoCall,
    required this.fileUpload,
    required this.language,
    required this.transcript,
    required this.historyMonitorType,
    required this.forceAcceptDataProcessingConsent,
    required this.showConnecting,
    required this.agentHiddenInfo,
  });

  factory Settings.fromJson(Map<String, dynamic> json) {
    return Settings(
        registrationForm: json['registrationForm'],
        allowSwitchingDepartments: json['allowSwitchingDepartments'],
        nameFieldRegistrationForm: json['nameFieldRegistrationForm'],
        emailFieldRegistrationForm: json['emailFieldRegistrationForm'],
        displayOfflineForm: json['displayOfflineForm'],
        videoCall: json['videoCall'],
        fileUpload: json['fileUpload'],
        language: json['language'],
        transcript: json['transcript'],
        historyMonitorType: json['historyMonitorType'],
        forceAcceptDataProcessingConsent:
            json['forceAcceptDataProcessingConsent'],
        showConnecting: json['showConnecting'],
        agentHiddenInfo: json['agentHiddenInfo']);
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['registrationForm'] = registrationForm;
    data['allowSwitchingDepartments'] = allowSwitchingDepartments;
    data['nameFieldRegistrationForm'] = nameFieldRegistrationForm;
    data['emailFieldRegistrationForm'] = emailFieldRegistrationForm;
    data['displayOfflineForm'] = displayOfflineForm;
    data['videoCall'] = videoCall;
    data['fileUpload'] = fileUpload;
    data['language'] = language;
    data['transcript'] = transcript;
    data['historyMonitorType'] = historyMonitorType;
    data['forceAcceptDataProcessingConsent'] = forceAcceptDataProcessingConsent;
    data['showConnecting'] = showConnecting;
    data['agentHiddenInfo'] = agentHiddenInfo;
    return data;
  }

  @override
  String toString() {
    return "Agent hiddent info=> $agentHiddenInfo";
  }
}

class Theme {
  String title;
  String color;
  String offlineTitle;
  String offlineColor;
  List<ActionLinks>? actionLinks;

  Theme({
    required this.title,
    required this.color,
    required this.offlineTitle,
    required this.offlineColor,
    this.actionLinks,
  });

  factory Theme.fromJson(Map<String, dynamic> json) {
    return Theme(
        title: json['title'],
        color: json['color'],
        offlineTitle: json['offlineTitle'],
        offlineColor: json['offlineColor'],
        actionLinks: json['actionLinks'] != null
            ? (json['actionLinks'] as List)
                .map((e) => ActionLinks.fromJson(e))
                .toList()
            : null);
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['title'] = title;
    data['color'] = color;
    data['offlineTitle'] = offlineTitle;
    data['offlineColor'] = offlineColor;
    if (actionLinks != null) {
      data['actionLinks'] = actionLinks!.map((v) => v.toJson()).toList();
    }
    return data;
  }
}

class ActionLinks {
  String icon;
  String i18nLabel;
  String methodId;
  String params;

  ActionLinks({
    required this.icon,
    required this.i18nLabel,
    required this.methodId,
    required this.params,
  });

  factory ActionLinks.fromJson(Map<String, dynamic> json) {
    return ActionLinks(
        icon: json['icon'],
        i18nLabel: json['i18nLabel'],
        methodId: json['method_id'],
        params: json['params']);
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['icon'] = icon;
    data['i18nLabel'] = i18nLabel;
    data['method_id'] = methodId;
    data['params'] = params;
    return data;
  }
}

class Messages {
  String offlineMessage;
  String offlineSuccessMessage;
  String offlineUnavailableMessage;
  String conversationFinishedMessage;
  String conversationFinishedText;
  String transcriptMessage;
  String registrationFormMessage;
  String dataProcessingConsentText;

  Messages({
    required this.offlineMessage,
    required this.offlineSuccessMessage,
    required this.offlineUnavailableMessage,
    required this.conversationFinishedMessage,
    required this.conversationFinishedText,
    required this.transcriptMessage,
    required this.registrationFormMessage,
    required this.dataProcessingConsentText,
  });

  factory Messages.fromJson(Map<String, dynamic> json) {
    return Messages(
        offlineMessage: json['offlineMessage'],
        offlineSuccessMessage: json['offlineSuccessMessage'],
        offlineUnavailableMessage: json['offlineUnavailableMessage'],
        conversationFinishedMessage: json['conversationFinishedMessage'],
        conversationFinishedText: json['conversationFinishedText'],
        transcriptMessage: json['transcriptMessage'],
        registrationFormMessage: json['registrationFormMessage'],
        dataProcessingConsentText: json['dataProcessingConsentText']);
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['offlineMessage'] = offlineMessage;
    data['offlineSuccessMessage'] = offlineSuccessMessage;
    data['offlineUnavailableMessage'] = offlineUnavailableMessage;
    data['conversationFinishedMessage'] = conversationFinishedMessage;
    data['conversationFinishedText'] = conversationFinishedText;
    data['transcriptMessage'] = transcriptMessage;
    data['registrationFormMessage'] = registrationFormMessage;
    data['dataProcessingConsentText'] = dataProcessingConsentText;
    return data;
  }
}

class Survey {
  List<String> items;
  List<String> values;

  Survey({required this.items, required this.values});

  factory Survey.fromJson(Map<String, dynamic> json) {
    return Survey(
        items: json['items'].cast<String>(),
        values: json['values'].cast<String>());
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['items'] = items;
    data['values'] = values;
    return data;
  }
}

class Trigger {
  static Trigger? fromJson(v) {
    return null; // finish
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    return data;
  }
}

class Departments {
  String sId;
  String name;
  bool showOnRegistration;
  bool showOnOfflineForm;

  Departments({
    required this.sId,
    required this.name,
    required this.showOnRegistration,
    required this.showOnOfflineForm,
  });

  factory Departments.fromJson(Map<String, dynamic> json) {
    return Departments(
        sId: json['_id'],
        name: json['name'],
        showOnRegistration: json['showOnRegistration'],
        showOnOfflineForm: json['showOnOfflineForm']);
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['_id'] = sId;
    data['name'] = name;
    data['showOnRegistration'] = showOnRegistration;
    data['showOnOfflineForm'] = showOnOfflineForm;
    return data;
  }
}

class Emoji {
  static Emoji? fromJson(v) {
    return null; // finish
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    return data;
  }
}

class Resources {
  String sound;
  List<Emoji>? emojis;

  Resources({required this.sound, this.emojis});

  factory Resources.fromJson(Map<String, dynamic> json) {
    return Resources(
      sound: json['sound'],
      emojis: null,
      // emojis: json['emojis'] != null
      //     ? (json['emojis'] as List).map((e) => Emoji.fromJson(e)!).toList()
      //     : null
    );
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['sound'] = sound;
    // if (emojis != null) {
    //   data['emojis'] = emojis.map((v) => v.toJson()).toList();
    // }
    return data;
  }
}

class Guest {
  String sId;
  String username;
  String name;
  String token;
  List<VisitorEmails>? visitorEmails;
  String department;

  Guest({
    required this.sId,
    required this.username,
    required this.name,
    required this.token,
    this.visitorEmails,
    required this.department,
  });

  factory Guest.fromJson(Map<String, dynamic> json) {
    return Guest(
        sId: json['_id'],
        username: json['username'],
        name: json['name'],
        token: json['token'],
        visitorEmails: (json['visitorEmails'] != null)
            ? (json['visitorEmails'] as List)
                .map((e) => VisitorEmails.fromJson(e))
                .toList()
            : null,
        department: json['department']);
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['_id'] = sId;
    data['username'] = username;
    data['name'] = name;
    data['token'] = token;
    if (visitorEmails != null) {
      data['visitorEmails'] = visitorEmails!.map((v) => v.toJson()).toList();
    }
    data['department'] = department;
    return data;
  }
}

class VisitorEmails {
  String address;

  VisitorEmails({required this.address});

  factory VisitorEmails.fromJson(Map<String, dynamic> json) {
    return VisitorEmails(address: json['address']);
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['address'] = address;
    return data;
  }
}
//
// class Room {
//   Room({
//     this.id,
//     // this.servedBy,
//     this.open,
//   });
//
//   String id;
//
//   // ServedBy servedBy;
//   bool open;
//
//   factory Room.fromJson(Map<String, dynamic> json) => Room(
//         id: json["_id"],
//         // servedBy: ServedBy.fromJson(json["servedBy"]),
//         open: json["open"],
//       );
//
//   Map<String, dynamic> toJson() => {
//         "_id": id,
//         // "servedBy": servedBy.toJson(),
//         "open": open,
//       };
// }
