class LivechatMessage {
  final String? sId;
  final String? roomId;
  final String? msg;
  final FileClass? file;
  List<Attachment>? attachments;
  final String? t;
  final DateTime? timestamp;
  final String? token;
  final String? alias;
  final User? u;

  LivechatMessage({
    this.sId,
    this.roomId,
    this.msg,
    this.file,
    this.attachments,
    this.t,
    this.timestamp,
    this.token,
    this.alias,
    this.u,
  });

  factory LivechatMessage.fromJson(Map<String, dynamic> json) {
    return LivechatMessage(
      sId: json['_id'],
      roomId: json['rid'],
      token: json['token'],
      alias: json['alias'],
      t: json['t'],
      msg: json['msg'],
      file: json["file"] != null ? FileClass.fromJson(json["file"]) : null,
      attachments: json["attachments"] != null
          ? List<Attachment>.from(
              json["attachments"].map((x) => Attachment.fromJson(x)))
          : null,
      timestamp:
          (json['ts'] is Map) ? DateTime.now() : DateTime.parse(json['ts']),
      u: json['u'] != null ? User.fromJson(json['u']) : null,
    );
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['_id'] = sId;
    data['rid'] = roomId;
    if (msg != null) data['msg'] = msg;
    if (file != null) {
      data['file'] = file;
    }
    data['ts'] = timestamp;
    data['token'] = token;
    data['t'] = t;
    data['alias'] = alias;
    if (u != null) {
      data['u'] = u!.toJson();
    }
    return data;
  }

  @override
  String toString() {
    return "history message:  $msg, from whom: $t, alias: $alias,  uuu: ${u.toString()}";
  }
}

class FileClass {
  FileClass({
    required this.id,
    required this.name,
    required this.type,
  });

  String id;
  String name;
  String type;

  factory FileClass.fromJson(Map<String, dynamic> json) => FileClass(
        id: json["_id"],
        name: json["name"],
        type: json["type"],
      );

  Map<String, dynamic> toJson() => {
        "_id": id,
        "name": name,
        "type": type,
      };
}

class Attachment {
  Attachment({
    this.ts,
    required this.title,
    required this.titleLink,
    required this.titleLinkDownload,
    required this.type,
    required this.description,
  });

  DateTime? ts;
  String title;
  String titleLink;
  bool titleLinkDownload;
  String type;
  String description;

  factory Attachment.fromJson(Map<String, dynamic> json) => Attachment(
        ts: json["ts"] == null ? DateTime.now() : DateTime.parse(json["ts"]),
        title: json["title"],
        titleLink: json["title_link"],
        titleLinkDownload: json["title_link_download"],
        type: json["type"],
        description: json["description"],
      );

  Map<String, dynamic> toJson() => {
        "ts": ts?.toIso8601String() ?? DateTime.now(),
        "title": title,
        "title_link": titleLink,
        "title_link_download": titleLinkDownload,
        "type": type,
        "description": description,
      };
}

class User {
  final String sId;
  final String username;
  final String name;

  User({
    required this.sId,
    required this.username,
    required this.name,
  });

  factory User.fromJson(Map<String, dynamic> json) {
    return User(
      sId: json['_id'],
      username: json['username'],
      name: json['name'],
    );
  }

  Map<String, dynamic> toJson() {
    final data = <String, dynamic>{};
    data['_id'] = sId;
    data['username'] = username;
    data['name'] = name;
    return data;
  }
}
