import 'dart:io';

import 'package:dio/adapter.dart';
import 'package:dio/dio.dart';
import 'package:road24_mobile/utils/check_internet.dart';
import 'package:road24_mobile/data/http/ApiResponse.dart';
import 'package:road24_mobile/data/response/manual_part/fines/FinesManualVersionResponse.dart';
import 'package:road24_mobile/view/manual/parts/fines/fines_manual.dart';

import '../../my_app.dart';

class FinesManualMixin {
  getBasicCalculationAmount() async {
    if (!await CheckInternet.isInternet()) {
      MyApp.hasInternet.value = false;
    }
    try {
      final response = await getBaseAmount();

      if (response != null) {
        FinesManualVersionResponse versionResponse =
            FinesManualVersionResponse.fromJson(
                ApiResponse.fromJson(response.data).data);

        FinesManual.basicCalculationAmount =
            versionResponse.basicCalculationAmount;
      }
    } catch (ex) {
      print("Exception on reading firebase storage...$ex");
    }
  }

  Future<dynamic> getBaseAmount() async {
    certificateEnable();

    final response =
        await dio.get("https://directus.yhxbb.uz/items/road24_settings");

    print(response);
    final result = Response(
      requestOptions: response.requestOptions,
      headers: response.headers,
      statusCode: response.statusCode,
      statusMessage: response.statusMessage,
      data: {
        "name": 'traffic-fines',
        "version": int.parse(response.data['data'][0]['traffic_fine_version']),
        "comment": '',
        "basic_calculation_amount":
            int.parse(response.data['data'][0]['basic_calculation_amount']),
      },
    );
    return result;
  }

  Dio dio = Dio();
  certificateEnable() {
    (dio.httpClientAdapter as DefaultHttpClientAdapter).onHttpClientCreate =
        (HttpClient client) {
      client.badCertificateCallback =
          (X509Certificate cert, String host, int port) => true;
      return client;
    };
  }
}
