part of 'user_bloc.dart';

abstract class UserState extends Equatable {
  const UserState();
}

class UserInitial extends UserState {
  @override
  List<Object> get props => [];
}

class UserLoadingError extends UserState {
  final dynamic exception;

  UserLoadingError({this.exception});
  @override
  List<Object> get props => [];
}

class GetUserSuccessState extends UserState {
  final UserResponse response;

  GetUserSuccessState({required this.response});
  @override
  List<Object> get props => [response];
}

class UserUpdateSuccessState extends UserState {
  @override
  List<Object> get props => [];
}

class NoLocationFound extends UserState {
  @override
  List<Object> get props => [];
}

class LocationFound extends UserState {
  @override
  List<Object> get props => [];
}
