part of 'user_bloc.dart';

abstract class UserEvent extends Equatable {
  const UserEvent();
}

class GetUserEvent extends UserEvent {
  @override
  List<Object> get props => [];
}

class UpdateUserEvent extends UserEvent {
  final String firstName;
  final String lastName;
  final String email;
  final String gender;
  final String birthday;
  UpdateUserEvent(
      {required this.firstName,
      required this.lastName,
      this.email = "",
      this.gender = "",
      this.birthday = ""});
  @override
  List<Object> get props => [firstName, lastName, email, gender, birthday];
}

class GetUserLocation extends UserEvent {
  @override
  List<Object?> get props => [];
}
