import 'dart:async';
import 'dart:io';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:road24_mobile/data/repository/UploadFileRepository.dart';
import 'package:road24_mobile/data/response/FileUploadResponse.dart';

part 'upload_files_event.dart';

part 'upload_files_state.dart';

class UploadfilesBloc extends Bloc<UploadfilesEvent, UploadfilesState> {
  final UploadFileRepository repository;

  UploadfilesBloc({required this.repository}) : super(UploadfilesInitial());

  @override
  Stream<UploadfilesState> mapEventToState(
    UploadfilesEvent event,
  ) async* {
    if (event is UploadFiles) {
      try {
        yield UploadfilesInitial();
        final dynamic response = await repository.uploadFilesToServer(
          fileName: event.fileName,
          filePath: event.filePath,
          module: event.module,
        );
        print(response);
        yield UploadfilesSuccessState(
          response: FileUploadResponse.fromJson(response),
        );
      } catch (e) {
        yield UploadfilesLoadingError(exception: e);
      }
    }
  }
}
