import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:road24_mobile/data/repository/ProblemRepository.dart';
import 'package:road24_mobile/data/response/ProblemsResponse.dart';

part 'situations_event.dart';
part 'situations_state.dart';

class SituationsBloc extends Bloc<SituationsEvent, SituationsState> {
  final ProblemRepository repository;

  SituationsBloc({required this.repository}) : super(SituationsInitial());

  @override
  Stream<SituationsState> mapEventToState(
    SituationsEvent event,
  ) async* {
    if (event is GetProblemsEvent) {
      try {
        yield SituationsInitial();
        final dynamic response = await repository.getProblems(
          page: event.page,
          pageSize: event.pageSize,
        );
        yield GetProblemsSuccessState(
          response: ProblemsResponse.fromJson(response),
        );
      } catch (e) {
        yield SituationsLoadingError(exception: e);
      }
    }
  }
}
