import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:road24_mobile/data/repository/ProblemRepository.dart';
import 'package:road24_mobile/data/response/ProblemDetailResponse.dart';

part 'problem_vote_event.dart';
part 'problem_vote_state.dart';

class ProblemVoteBloc extends Bloc<ProblemVoteEvent, ProblemVoteState> {
  final ProblemRepository repository;
  ProblemVoteBloc({required this.repository}) : super(ProblemVoteInitial());

  @override
  Stream<ProblemVoteState> mapEventToState(
    ProblemVoteEvent event,
  ) async* {
    if (event is VoteToProblemEvent) {
      try {
        yield ProblemVoteLoading();
        final response = await repository.upVoteProblem(id: event.id);
        VoteResponse voteResponse = VoteResponse.fromJson(response);
        yield ProblemVoteSuccessState(response: voteResponse);
      } catch (e) {
        print('error');
        yield ProblemVoteError(exception: e);
      }
    }
  }
}
