import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:road24_mobile/data/repository/ProblemRepository.dart';
import 'package:road24_mobile/data/response/ProblemDetailResponse.dart';

part 'problem_detail_event.dart';
part 'problem_detail_state.dart';

class ProblemDetailBloc extends Bloc<ProblemDetailEvent, ProblemDetailState> {
  final ProblemRepository repository;

  ProblemDetailBloc({required this.repository}) : super(ProblemDetailInitial());

  @override
  Stream<ProblemDetailState> mapEventToState(
    ProblemDetailEvent event,
  ) async* {
    if (event is GetProblemDetailEvent) {
      try {
        yield ProblemDetailInitial();
        final dynamic response = await repository.getProblem(id: event.id);
        yield GetProblemDetailSuccessState(
          response: ProblemDetail.fromJson(response),
        );
      } catch (e) {
        yield ProblemDetailLoadingError(exception: e);
      }
    }
  }
}
