import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:road24_mobile/data/repository/ProblemRepository.dart';
import 'package:road24_mobile/model/models/AddressModel.dart';

part 'add_new_problem_event.dart';

part 'add_new_problem_state.dart';

class AddNewProblemBloc extends Bloc<AddNewProblemEvent, AddNewProblemState> {
  final ProblemRepository repository;

  AddNewProblemBloc({required this.repository}) : super(AddNewProblemInitial());

  @override
  Stream<AddNewProblemState> mapEventToState(
    AddNewProblemEvent event,
  ) async* {
    if (event is AddNewProblem) {
      try {
        yield AddNewProblemInitial();
        await repository.addProblem(
          description: event.description,
          kind: event.kind,
          photoIds: event.photoIds,
        );
        yield AddNewProblemSuccessState();
      } catch (e) {
        yield AddNewProblemLoadingError(exception: e);
      }
    }
  }
}
