part of 'reports_bloc.dart';

abstract class ReportsState extends Equatable {
  const ReportsState();
}

class ReportsInitial extends ReportsState {
  @override
  List<Object> get props => [];
}

class ReportsLoadingError extends ReportsState {
  final dynamic exception;

  ReportsLoadingError({this.exception});
  @override
  List<Object> get props => [exception];
}

class GetReportsSuccessState extends ReportsState {
  final ReportsResponse response;

  GetReportsSuccessState({required this.response});
  @override
  List<Object> get props => [response];
}

class CreateNewReportsSuccessState extends ReportsState {
  final ReportsResponse response;

  CreateNewReportsSuccessState({required this.response});
  @override
  List<Object> get props => [response];
}

class ReportDetailInitial extends ReportsState {
  @override
  List<Object> get props => [];
}

class ReportDetailError extends ReportsState {
  final dynamic exception;

  ReportDetailError({this.exception});

  @override
  List<Object> get props => [exception];
}

class GetReportDetailSuccessState extends ReportsState {
  final ReportDetailResponse response;

  GetReportDetailSuccessState(this.response);

  @override
  List<Object> get props => [response];
}
