part of 'reports_bloc.dart';

abstract class ReportsEvent extends Equatable {
  const ReportsEvent();
}

class GetReportsEvent extends ReportsEvent {
  final int page;
  final int pageSize;

  GetReportsEvent({required this.page, required this.pageSize});
  @override
  List<Object> get props => [page, pageSize];
}

class CreateNewReportsEvent extends ReportsEvent {
  final String type;
  final String number;

  CreateNewReportsEvent({required this.type, required this.number});

  @override
  List<Object> get props => [type, number];
}

class GetSingleReportDetailEvent extends ReportsEvent {
  final int id;

  GetSingleReportDetailEvent(this.id);

  @override
  List<Object> get props => [id];
}
