import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:road24_mobile/data/repository/CardRepository.dart';

part 'payment_event.dart';

part 'payment_state.dart';

class PaymentBloc extends Bloc<PaymentEvent, PaymentState> {
  final CardRepository repository;
  PaymentBloc({required this.repository}) : super(PaymentInitial());

  @override
  Stream<PaymentState> mapEventToState(
    PaymentEvent event,
  ) async* {
    if (event is PayFine) {
      try {
        yield PaymentInitial();
        final response = await repository
            .pay(event.fineId, event.cardId, event.sum, smsCode: event.smsCode);
        print("error:..." + response.error.toString());
        print("pay response:" + response.toString());
        yield PaymentRequestAccepted(response.data);
      } catch (e) {
        yield PaymentError(e.toString());
      }
    }
  }
}
