import 'package:flutter_bloc/flutter_bloc.dart';

class Observer extends BlocObserver {
  @override // 1.
  void onEvent(Bloc bloc, Object? event) {
    super.onEvent(bloc, event);
    print(event);
  }

  @override // 2.
  void onTransition(Bloc bloc, Transition transition) {
    super.onTransition(bloc, transition);
    print(transition);
  }

  @override // 3.
  void onError(BlocBase bloc, Object error, StackTrace stackTrace) {
    super.onError(bloc, error, stackTrace);
    print('$error | $stackTrace');
  }
}
