part of 'notifications_bloc.dart';

abstract class NotificationsState extends Equatable {
  const NotificationsState();
}

class NotificationsInitial extends NotificationsState {
  @override
  List<Object> get props => [];
}

class GetNotificationsSuccessState extends NotificationsState {
  final NotificationResponse response;

  GetNotificationsSuccessState({required this.response});
  @override
  List<Object> get props => [response];
}

class GetNotificationsDetailsSuccessState extends NotificationsState {
  final String markdownStr;

  GetNotificationsDetailsSuccessState({required this.markdownStr});
  @override
  List<Object> get props => [markdownStr];
}

class GetUnreadNotificationsCountSuccessState extends NotificationsState {
  final UnreadNotificationsCountResponse response;

  GetUnreadNotificationsCountSuccessState({required this.response});
  @override
  List<Object> get props => [response];
}

class NotificationLoadingError extends NotificationsState {
  final dynamic exception;

  NotificationLoadingError(this.exception);

  @override
  List<Object> get props => [exception];
}

class UserReadNotificationState extends NotificationsState {
  final Results result;

  UserReadNotificationState({required this.result});
  @override
  List<Object> get props => [result];
}
