part of 'notifications_bloc.dart';

abstract class NotificationsEvent extends Equatable {
  const NotificationsEvent();
}

class GetNotificationsEvent extends NotificationsEvent {
  final int page;
  final int pageSize;

  GetNotificationsEvent({required this.page, required this.pageSize});

  @override
  List<Object> get props => [page, pageSize];
}

class GetNotificationDetailsEvent extends NotificationsEvent {
  final int id;

  GetNotificationDetailsEvent({
    required this.id,
  });

  @override
  List<Object> get props => [id];
}

class GetUnreadNotificationsCountEvent extends NotificationsEvent {
  @override
  List<Object> get props => throw UnimplementedError();
}

class UserReadNotificationEvent extends NotificationsEvent {
  final int id;

  UserReadNotificationEvent(this.id);

  @override
  List<Object> get props => [id];
}
