part of 'news_bloc.dart';

abstract class NewsState extends Equatable {
  const NewsState();
}

class NewsInitial extends NewsState {
  @override
  List<Object> get props => [];
}

class NewsLoadingError extends NewsState {
  final dynamic exception;

  NewsLoadingError({this.exception});
  @override
  List<Object> get props => [];
}

class GetNewsSuccessState extends NewsState {
  final NewsResponse response;

  GetNewsSuccessState({required this.response});
  @override
  List<Object> get props => [response];
}

class ReadNewsSuccessState extends NewsState {
  final NewsResults results;

  ReadNewsSuccessState({required this.results});
  @override
  List<Object> get props => [];
}
