part of 'cars_bloc.dart';

abstract class CarsState extends Equatable {
  const CarsState();
}

class CarsInitial extends CarsState {
  @override
  List<Object> get props => [];
}

class CarsLoadingError extends CarsState {
  final dynamic exception;
  final dynamic response;

  CarsLoadingError({this.exception, this.response});
  @override
  List<Object> get props => [];
}

class CarListSuccessState extends CarsState {
  final CarsResponse response;

  CarListSuccessState({required this.response});
  @override
  List<Object> get props => [response];
}

class GetCarDetailsSuccessState extends CarsState {
  final CarDetailsResponse response;

  GetCarDetailsSuccessState({required this.response});
  @override
  List<Object> get props => [response];
}

class AddCarSuccessState extends CarsState {
  @override
  List<Object> get props => [];
}

class EditCarSuccessState extends CarsState {
  @override
  List<Object> get props => [];
}

class DeleteCarSuccessState extends CarsState {
  @override
  List<Object> get props => [];
}

class CarExistResult extends CarsState {
  final bool isExist;

  CarExistResult(this.isExist);

  @override
  List<Object?> get props => [isExist];
}

class OilListResult extends CarsState {
  final List<Oil> oilList;

  OilListResult(this.oilList);

  @override
  List<Object?> get props => [oilList];
}

class OilNextReplaceCalculated extends CarsState {
  final int nextMileage;
  final String nextReplacementDate;

  OilNextReplaceCalculated(this.nextMileage, this.nextReplacementDate);

  @override
  List<Object?> get props => [this.nextMileage, this.nextReplacementDate];
}
