part of 'cars_bloc.dart';

abstract class CarsEvent extends Equatable {
  const CarsEvent();
}

class GetCars extends CarsEvent {
  @override
  List<Object> get props => [];
}

class GetCarDetails extends CarsEvent {
  final int id;

  GetCarDetails(this.id);

  @override
  List<Object> get props => [id];
}

class AddCar extends CarsEvent {
  final String fileName;
  final String? filePath;

  AddCar({required this.fileName, this.filePath});
  @override
  List<Object> get props => [
        {fileName, filePath}
      ];
}

class EditCar extends CarsEvent {
  final int id;
  final String fileName;
  final String? filePath;

  EditCar(this.id, {required this.fileName, this.filePath});

  @override
  List<Object?> get props => [fileName, filePath];
}

class EditCarConfidant extends CarsEvent {
  final int id;

  EditCarConfidant(this.id);

  @override
  List<Object> get props => [];
}

class EditCarInspection extends CarsEvent {
  final int id;

  EditCarInspection(this.id);

  @override
  List<Object> get props => [];
}

class EditCarInsurance extends CarsEvent {
  final int id;

  EditCarInsurance(this.id);

  @override
  List<Object> get props => [];
}

class EditCarTinting extends CarsEvent {
  final int id;

  EditCarTinting(this.id);

  @override
  List<Object> get props => [];
}

class EditCarOil extends CarsEvent {
  final int id;
  final AddOilModel model;
  final DateTime lastReplaceDate;

  EditCarOil(this.id, this.model, this.lastReplaceDate);

  @override
  List<Object> get props => [id, model, lastReplaceDate];
}

class OilCalculateNextDate extends CarsEvent {
  final DateTime lastOilDate;
  final int dailyMileage;
  final int oilInterval;
  final int mileage;

  OilCalculateNextDate(
      {required this.lastOilDate,
      required this.dailyMileage,
      required this.oilInterval,
      required this.mileage});

  @override
  List<Object> get props => [mileage, lastOilDate, dailyMileage, oilInterval];
}

class DeleteCar extends CarsEvent {
  final int id;

  DeleteCar(this.id);

  @override
  List<Object> get props => [];
}

class CheckCarExistence extends CarsEvent {
  final String plateNumber;
  final String techNumber;

  CheckCarExistence({
    required this.plateNumber,
    required this.techNumber,
  });

  @override
  List<Object> get props => [plateNumber, techNumber];
}

class GetCarOilList extends CarsEvent {
  final int carDetailId;

  GetCarOilList({
    required this.carDetailId,
  });

  @override
  List<Object> get props => [carDetailId];
}
