part of 'inspections_bloc.dart';

abstract class InspectionsState extends Equatable {
  const InspectionsState();
}

class InspectionsInitial extends InspectionsState {
  @override
  List<Object> get props => [];
}

class InspectionsLoadingError extends InspectionsState {
  final dynamic exception;

  InspectionsLoadingError({this.exception});
  @override
  List<Object> get props => [];
}

class GetInspectionPlacesSuccessState extends InspectionsState {
  final InspectionPlacesResponse response;

  GetInspectionPlacesSuccessState({required this.response});
  @override
  List<Object> get props => [response];
}

class GetRegionSuccessState extends InspectionsState {
  final List<Regions> regions;

  GetRegionSuccessState({required this.regions});
  @override
  List<Object> get props => [regions];
}

class GetPlacesSuccessState extends InspectionsState {
  final List<Address> address;
  final List<Districts> district;

  GetPlacesSuccessState({required this.address, required this.district});
  @override
  List<Object> get props => [address, district];
}

class LoadingState extends InspectionsState {
  @override
  List<Object> get props => [];
}

class InspectionStatus extends InspectionsState {
  final StatusType statusType;
  final String? datePassed;
  final String? dateEnd;
  final String? pDivision;

  InspectionStatus(
      {this.datePassed,
      this.dateEnd,
      this.pDivision,
      required this.statusType});
  @override
  List<Object?> get props => [statusType, dateEnd, datePassed, pDivision];
}

class InspectionRefreshedState extends InspectionsState {
  final String? datePassed;
  final String? dateEnd;
  final String? pDivision;

  InspectionRefreshedState(
      {required this.datePassed,
      required this.dateEnd,
      required this.pDivision});

  @override
  List<Object?> get props => [dateEnd, datePassed, pDivision];
}
