part of 'inspections_bloc.dart';

abstract class InspectionsEvent extends Equatable {
  const InspectionsEvent();
}

class GetInspectionPlacesEvent extends InspectionsEvent {
  @override
  List<Object> get props => [];
}

class GetRegionsEvent extends InspectionsEvent {
  @override
  List<Object> get props => [];
}

class GetListOfPlacesEvent extends InspectionsEvent {
  final int regionId;

  GetListOfPlacesEvent({required this.regionId});

  @override
  List<Object> get props => [regionId];
}

class CheckStatus extends InspectionsEvent {
  final String? dateEnd;
  final String? dateStart;
  final String? pDivision;

  CheckStatus({this.dateEnd, this.dateStart, this.pDivision});

  @override
  List<Object?> get props => [dateEnd, dateStart, pDivision];
}

class RefreshedInspectionInfo extends InspectionsEvent {
  final int carId;

  RefreshedInspectionInfo({required this.carId});

  @override
  List<Object?> get props => [carId];
}
