part of 'fines_bloc.dart';

abstract class FinesState extends Equatable {
  const FinesState();
}

class FinesInitial extends FinesState {
  @override
  List<Object> get props => [];
}

class FinesFail extends FinesState {
  final dynamic exception;

  FinesFail({this.exception});

  @override
  List<Object> get props => [];
}

class NotPaidFinesListSuccessState extends FinesState {
  final Fines response;

  NotPaidFinesListSuccessState({required this.response});

  @override
  List<Object> get props => [response];
}

class HistoryFinesListSuccessState extends FinesState {
  final Fines response;

  HistoryFinesListSuccessState({required this.response});

  @override
  List<Object> get props => [response];
}

class FineDetailSuccessState extends FinesState {
  final FineDetails response;

  FineDetailSuccessState({required this.response});

  @override
  List<Object> get props => [response];
}

class FineInfoSuccessState extends FinesState {
  final List<Categories> categories;
  final List<Articles> articles;

  FineInfoSuccessState({required this.categories, required this.articles});

  @override
  List<Object> get props => [categories];
}

class ArticlePartsSuccessState extends FinesState {
  final List<Parts> articleParts;

  ArticlePartsSuccessState({required this.articleParts});

  @override
  List<Object> get props => [articleParts];
}

class LoadingState extends FinesState {
  @override
  List<Object> get props => [];
}

class GetFinesManualFail extends FinesState {
  final dynamic exception;

  GetFinesManualFail({this.exception});

  @override
  List<Object> get props => [];
}

class BasicCalculationAmount extends FinesState {
  final int amount;

  BasicCalculationAmount(this.amount);
  @override
  List<Object> get props => [amount];
}
