part of 'fines_bloc.dart';

abstract class FinesEvent extends Equatable {
  const FinesEvent();
}

class GetFines extends FinesEvent {
  final int carId;
  final int pageNumber;
  final int pageSize;
  final List<int> types;
  GetFines(
      {required this.carId,
      required this.pageNumber,
      required this.pageSize,
      required this.types});
  @override
  List<Object> get props =>
      [this.carId, this.pageNumber, this.pageSize, this.types];
}

class GetFineDetails extends FinesEvent {
  final int id;
  GetFineDetails(this.id);
  @override
  List<Object> get props => [id];
}

class RefreshFineRemain extends FinesEvent {
  final int id;
  RefreshFineRemain(this.id);
  @override
  List<Object> get props => [id];
}

class GetCategories extends FinesEvent {
  @override
  List<Object> get props => [];
}

class GetArticleParts extends FinesEvent {
  final int? articleId;

  final String? article;

  GetArticleParts({this.articleId, this.article});

  @override
  List<Object?> get props => [articleId, article];
}

class GetBasicCalculationAmount extends FinesEvent {
  @override
  List<Object> get props => [];
}
