part of 'faq_bloc.dart';

abstract class FaqState extends Equatable {
  const FaqState();
}

class FaqsInitial extends FaqState {
  @override
  List<Object> get props => [];
}

class FaqsError extends FaqState {
  final dynamic exception;

  FaqsError({this.exception});
  @override
  List<Object> get props => [exception];
}

class FaqsSuccessState extends FaqState {
  final FAQModel response;

  FaqsSuccessState({required this.response});
  @override
  List<Object> get props => [response];
}

class FaqsLoadingState extends FaqState {
  @override
  List<Object> get props => [];
}

class MustKnowSuccessState extends FaqState {
  final MustKnowModel response;

  MustKnowSuccessState(this.response);
  @override
  List<Object> get props => [response];
}
