import 'dart:async';

import 'package:bloc/bloc.dart';
import 'package:equatable/equatable.dart';
import 'package:road24_mobile/data/repository/FaqRepository.dart';
import 'package:road24_mobile/data/repository/ManualDirectusRepository.dart';
import 'package:road24_mobile/data/response/manual_part/faq_model.dart';
import 'package:road24_mobile/model/models/must_know_model.dart';

part 'faq_event.dart';

part 'faq_state.dart';

class FAQBloc extends Bloc<FAQEvent, FaqState> {
  final FAQRepository repository;

  FAQBloc({required this.repository}) : super(FaqsInitial());

  @override
  Stream<FaqState> mapEventToState(FAQEvent event) async* {
    if (event is GetFAQList) {
      try {
        yield FaqsLoadingState();
        final dynamic response = await repository.getFaqList();
        yield FaqsSuccessState(response: FAQModel.fromJson(response));
      } catch (e) {
        print("get faq ERROR:...." + e.toString());
        yield FaqsError(exception: e);
      }
    } else if (event is GetMustKnowText) {
      try {
        yield FaqsLoadingState();

        final dynamic response =
            await ManualDirectusRepository().getMustKnowText();

        yield MustKnowSuccessState(response);
      } catch (e) {
        print("get must know ERROR:...." + e.toString());
        yield FaqsError(exception: e);
      }
    }
  }
}
