part of 'cheque_bloc.dart';

abstract class ChequeState extends Equatable {
  const ChequeState();
}

class ChequeInitialState extends ChequeState {
  @override
  List<Object> get props => [];
}

class ChequeLoadingState extends ChequeState {
  @override
  List<Object> get props => [];
}

class ChequeListSuccessState extends ChequeState {
  final dynamic response;

  ChequeListSuccessState({required this.response});
  @override
  List<Object> get props => [response];
}

class ChequeDetailsSuccessState extends ChequeState {
  final ChequeDetailsResponse response;

  ChequeDetailsSuccessState({required this.response});
  @override
  List<Object> get props => [response];
}

class ChequeErrorState extends ChequeState {
  final exception;

  ChequeErrorState({this.exception});
  @override
  List<Object> get props => [exception];
}
