part of 'card_bloc.dart';

abstract class CardState extends Equatable {
  const CardState();
}

class CardInitial extends CardState {
  @override
  List<Object> get props => [];
}

class AddCardSuccessState extends CardState {
  final CardResults response;

  AddCardSuccessState(this.response);
  @override
  List<Object> get props => [response];
}

class GetCardSuccessState extends CardState {
  final CardResults response;

  GetCardSuccessState({required this.response});
  @override
  List<Object> get props => [response];
}

class CardLoadingError extends CardState {
  final dynamic exception;

  CardLoadingError({required this.exception});
  @override
  List<Object> get props => [exception];
}

class GetCardsSuccessState extends CardState {
  final GetCardsResponse response;

  GetCardsSuccessState({required this.response});
  @override
  List<Object> get props => [response];
}

class DeleteCardSuccessState extends CardState {
  @override
  List<Object> get props => [];
}

class CardIsVerifiedSuccessState extends CardState {
  @override
  List<Object> get props => [];
}

class VerificationCodeResent extends CardState {
  @override
  List<Object> get props => [];
}
