part of 'card_bloc.dart';

abstract class CardEvent extends Equatable {
  const CardEvent();
}

class AddCardEvent extends CardEvent {
  final String cardNumber;
  final String expire;
  final String name;

  AddCardEvent(
      {required this.cardNumber, required this.expire, required this.name});

  @override
  List<Object> get props => [cardNumber, expire, name];
}

class GetCardsEvent extends CardEvent {
  @override
  List<Object> get props => [];
}

class GetCardEvent extends CardEvent {
  final int id;

  GetCardEvent(this.id);
  @override
  List<Object> get props => [id];
}

class EditCardEvent extends CardEvent {
  final int id;

  EditCardEvent(this.id);
  @override
  List<Object> get props => [id];
}

class DeleteCardEvent extends CardEvent {
  final int id;

  DeleteCardEvent(this.id);
  @override
  List<Object> get props => [id];
}

class ResendVerificationCodeEvent extends CardEvent {
  final int id;

  ResendVerificationCodeEvent(this.id);
  @override
  List<Object> get props => [id];
}

class VerifyCardEvent extends CardEvent {
  final int id;
  final String code;

  VerifyCardEvent(this.id, this.code);
  @override
  List<Object> get props => [id, code];
}
